package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * @author y.zhao
 * @title: ActOrderEntity
 * @projectName tuia-payment
 * @description: description
 * @date 2024.07.02 15:13
 */
@Getter
@Setter
@TableName("tb_act_order")
public class ActOrderEntity implements Serializable {

    private static final long serialVersionUID = -5573615024748415658L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 更新时间
     */
    @TableField(value = "gmt_modified", update = "CURRENT_TIMESTAMP")
    private Date gmtModified;

    /**
     * 用户id
     */
    @TableField("user_id")
    private Long userId;

    /**
     * tuiaId
     */
    @TableField("tuia_id")
    private String tuiaId;

    /**
     * jimuId
     */
    @TableField("jimu_id")
    private String jimuId;

    /**
     * 内部订单号
     */
    @TableField("order_no")
    private String orderNo;

    /**
     * 状态
     *
     * @see cn.tuia.payment.params.enums.ActOrderStatusEnum
     */
    @TableField("status")
    private Integer status;

    /**
     * 可支付金额
     */
    @TableField("original_amount")
    private Long originalAmount;

    /**
     * 可提现金额
     */
    @TableField("original_cash_amount")
    private Long originalCashAmount;

    /**
     * 商品名
     */
    @TableField("goods_name")
    private String goodsName;

    /**
     * advertKey
     */
    @TableField("advert_key")
    private String advertKey;

    /**
     * 行业
     */
    @TableField("industry")
    private Integer industry;

    /**
     * 手机号
     */
    @TableField("phone")
    private String phone;

    /**
     * ip
     */
    @TableField("ip")
    private String ip;


    /**
     * 活动标记
     *
     * @see cn.tuia.payment.params.enums.ActOrderFlagEnum
     */
    @TableField("act_flag")
    private Integer actFlag;
}
