package cn.tuia.payment.api.enums;

import com.google.common.base.Strings;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author y.zhao
 * @title: PayStatusLeshuaEnum
 * @projectName tuia-payment
 * @description: description
 * @date 2025.01.10 14:33
 */
@Getter
@AllArgsConstructor
public enum PayStatusLeshuaEnum {
    //订单状态
    // 0	支付中
    //2	支付成功
    //6	订单关闭
    //8	支付失败
    USER_PAYING(PayStatusEnum.USER_PAYING, "0"),
    TRADE_SUCCESS(PayStatusEnum.TRADE_SUCCESS, "2"),//支付成功
    TRADE_FAIL(PayStatusEnum.TRADE_FAIL, "8"),//失败
    TRADE_CLOSE(PayStatusEnum.TRADE_CLOSE, "6"),//关闭
    ;

    private final PayStatusEnum insideCode;
    private final String outsideCode;

    public static Integer getByCode(String outsideCode) {
        if (Strings.isNullOrEmpty(outsideCode)) {
            return null;
        }
        for (PayStatusLeshuaEnum value : PayStatusLeshuaEnum.values()) {
            if (value.getOutsideCode().equals(outsideCode)) {
                return value.getInsideCode().getCode();
            }
        }
        return null;
    }
}
