package cn.tuia.payment.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.payment.api.dto.CompliantDTO;
import cn.tuia.payment.api.dto.req.BankMerQuery;
import cn.tuia.payment.api.dto.req.ComplaintQuery;
import cn.tuia.payment.api.dto.req.ReqPageQuery;
import cn.tuia.payment.api.dto.rsp.ResultPage;
import cn.tuia.payment.api.entity.CustomerComplaintEntity;

import java.util.List;

/**
 * @author y.zhao
 * @title: RemoteCustomerComplainService
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.08.06 13:58
 */
@AdvancedFeignClient
public interface RemoteCustomerComplainService {

    /**
     * 保存
     *
     * @param entity
     * @return
     */
    CustomerComplaintEntity save(CustomerComplaintEntity entity);


    /**
     * 保存的同时，返回是否存在
     * true已存在，false不存在，就新增
     */
    boolean saveAndReturnExist(CustomerComplaintEntity entity);

    /**
     * 分页查询
     *
     * @param query
     * @return
     */
    ResultPage<CompliantDTO> page(ReqPageQuery<ComplaintQuery> query);

    /**
     * 不分页查询
     *
     * @param query
     * @return
     */
    List<CompliantDTO> list(ComplaintQuery query);

    void syncRefundStatus();
}
