package cn.tuia.payment.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.payment.api.entity.PayOrderEntity;

import java.util.List;


/**
 * <p>
 * 用户主表 服务类
 * </p>
 *
 * @author hong
 * @since 2024/01/24
 */
@AdvancedFeignClient
public interface RemotePayOrderService {
    boolean save(PayOrderEntity payOrderEntity);

    boolean updateByMultiId(PayOrderEntity payOrderEntity);

    /**
     * 根据手机号或者流水号获取
     */
    PayOrderEntity getSuccessPayOrderByPhone(String phone);

    PayOrderEntity getSuccessPayOrderByPhoneInDays(String phone, Integer days);

    PayOrderEntity getLatestUnpaidOrderByPhoneInTwoDays(String phone);

    PayOrderEntity getLatestUnpaidOrderByPhoneInDays(String phone, Integer days);

    PayOrderEntity getSuccessOrderByTuiaIdAndPaymentChannel(String tuiaId, Integer paymentChannel);

    PayOrderEntity getByBankId(String bankId);

    PayOrderEntity getSuccessPayOrderByBankId(String bankId);

    PayOrderEntity getOrderByOrderId(String orderId);

    PayOrderEntity getLatestOrderByTuiaIdAndPaymentChannel(String tuiaId, Integer paymentChannel);

    PayOrderEntity getOrderByOrderIdAndTradeNo(String orderId, String tradeNo);

    Long countAllUnsuccessfulOrderToday(String tuiaId, Integer paymentChannel);

    /**
     * 查询 上个月所有支付未退款的订单
     */
    List<PayOrderEntity> getLastMonthPayOrder();

    List<PayOrderEntity> getTheSameDayLastMonthPayOrder4Page(int page, int pageSize);

    /**
     * 同步退款状态到订单表
     *
     * @param payOrderEntity
     */
    PayOrderEntity syncRefundStatus(PayOrderEntity payOrderEntity);

}
