/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.tools.deviceid;

import cn.tuia.tools.deviceid.DeviceDTO;
import cn.tuia.tools.deviceid.DeviceMd5BlackEnum;
import cn.tuia.tools.deviceid.DeviceTypeEnum;
import cn.tuia.tools.deviceid.LegalMd5Factory;
import cn.tuia.tools.deviceid.TempObjectMd5;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public class DeviceIdUtils {
    public static void checkAndGenerateDeviceId(DeviceDTO deviceDTO) {
        DeviceIdUtils.transferMd5DTO(deviceDTO);
        String deviceId = deviceDTO.getDeviceId();
        if (StringUtils.isNotEmpty((CharSequence)deviceId) && LegalMd5Factory.checkLegalMd5(deviceId, DeviceTypeEnum.DEVICE_ID)) {
            deviceDTO.setLegalFlag(true);
            deviceDTO.setDeviceType(DeviceTypeEnum.DEVICE_ID.getCode());
            return;
        }
        Integer deviceType = DeviceTypeEnum.UNKNOWN.getCode();
        if (StringUtils.isNotEmpty((CharSequence)deviceDTO.getImei_md5())) {
            deviceType = DeviceTypeEnum.IMEI.getCode();
            deviceId = deviceDTO.getImei_md5();
        } else if (StringUtils.isNotEmpty((CharSequence)deviceDTO.getIdfa_md5())) {
            deviceType = DeviceTypeEnum.IDFA.getCode();
            deviceId = deviceDTO.getIdfa_md5();
        } else if (StringUtils.isNotEmpty((CharSequence)deviceDTO.getOaid_md5())) {
            deviceType = DeviceTypeEnum.OAID.getCode();
            deviceId = deviceDTO.getOaid_md5();
        }
        if (!DeviceTypeEnum.UNKNOWN.getCode().equals(deviceType)) {
            deviceDTO.setLegalFlag(true);
            deviceDTO.setDeviceId(deviceId);
            deviceDTO.setDeviceType(deviceType);
            return;
        }
        deviceType = deviceDTO.getDeviceType();
        DeviceTypeEnum deviceTypeEnum = DeviceTypeEnum.seekValue(deviceType);
        String desc = deviceTypeEnum.getDesc();
        deviceId = DeviceIdUtils.getUUIDAndMd5(desc);
        deviceDTO.setLegalFlag(false);
        deviceDTO.setDeviceType(deviceTypeEnum.getCode());
        deviceDTO.setDeviceId(deviceId);
    }

    private static void transferMd5DTO(DeviceDTO deviceDTO) {
        TempObjectMd5 objectMd51 = new TempObjectMd5(deviceDTO.getImei(), deviceDTO.getImei_md5());
        DeviceIdUtils.checkLegalMd5(objectMd51, DeviceTypeEnum.IMEI);
        deviceDTO.setImei(objectMd51.getStr());
        deviceDTO.setImei_md5(objectMd51.getStrMd5());
        TempObjectMd5 objectMd52 = new TempObjectMd5(deviceDTO.getIdfa(), deviceDTO.getIdfa_md5());
        DeviceIdUtils.checkLegalMd5(objectMd52, DeviceTypeEnum.IDFA);
        deviceDTO.setIdfa(objectMd52.getStr());
        deviceDTO.setIdfa_md5(objectMd52.getStrMd5());
        TempObjectMd5 objectMd53 = new TempObjectMd5(deviceDTO.getOaid(), deviceDTO.getOaid_md5());
        DeviceIdUtils.checkLegalMd5(objectMd53, DeviceTypeEnum.OAID);
        deviceDTO.setOaid(objectMd53.getStr());
        deviceDTO.setOaid_md5(objectMd53.getStrMd5());
    }

    private static void checkLegalMd5(TempObjectMd5 objectMd5, DeviceTypeEnum typeEnum) {
        String strMd5;
        String str = objectMd5.getStr();
        if (LegalMd5Factory.checkLegalMd5(str, typeEnum)) {
            objectMd5.setStrMd5(DigestUtils.md5Hex((String)str));
            return;
        }
        objectMd5.setStr("");
        String imeiMd5Temp = "";
        if (LegalMd5Factory.isLowerCase32Md5(str)) {
            imeiMd5Temp = str;
        }
        if (!LegalMd5Factory.isLowerCase32Md5(strMd5 = objectMd5.getStrMd5())) {
            objectMd5.setStrMd5(imeiMd5Temp);
        }
    }

    public static String getUUIDAndMd5(String desc) {
        if (StringUtils.isEmpty((CharSequence)desc) || desc.length() > 6) {
            desc = DeviceTypeEnum.UNKNOWN.getDesc();
        }
        int length = desc.length();
        String uuid = UUID.randomUUID().toString() + System.currentTimeMillis();
        uuid = DigestUtils.md5Hex((String)uuid);
        uuid = desc + uuid.substring(length, uuid.length());
        return uuid;
    }

    public static void main(String[] args) {
        System.out.println("\u3010\u6d4b\u8bd5\u3011 imei \u5408\u6cd5\uff1a 351710058880864");
        DeviceDTO deviceDTO = DeviceDTO.builder().imei("351710058880864").deviceId("11").build();
        DeviceIdUtils.checkAndGenerateDeviceId(deviceDTO);
        System.out.println(deviceDTO);
        System.out.println("\u3010\u6d4b\u8bd5\u3011 idfa \u5408\u6cd5: CCD6E1CD-8C4B-40CB-8A62-4BBC7AFE07D6");
        deviceDTO = DeviceDTO.builder().idfa("CCD6E1CD-8C4B-40CB-8A62-4BBC7AFE07D6").deviceId("22").build();
        DeviceIdUtils.checkAndGenerateDeviceId(deviceDTO);
        System.out.println(deviceDTO);
        System.out.println("\u3010\u6d4b\u8bd5\u3011 oaid \u5408\u6cd5: 351710058880864");
        deviceDTO = DeviceDTO.builder().oaid("351710058880864").build();
        DeviceIdUtils.checkAndGenerateDeviceId(deviceDTO);
        System.out.println(deviceDTO);
        System.out.println("\u3010\u6d4b\u8bd5\u3011 imei Md5 \u5408\u6cd5: d41d8cd98f00b204e9800998ecf84271");
        deviceDTO = DeviceDTO.builder().imei_md5("d41d8cd98f00b204e9800998ecf84271").build();
        DeviceIdUtils.checkAndGenerateDeviceId(deviceDTO);
        System.out.println(deviceDTO);
        System.out.println("\u3010\u6d4b\u8bd5\u3011 idfa Md5 \u5408\u6cd5");
        deviceDTO = DeviceDTO.builder().idfa_md5("d41d8cd98f00b204e9800998ecf84272").build();
        DeviceIdUtils.checkAndGenerateDeviceId(deviceDTO);
        System.out.println(deviceDTO);
        System.out.println("\u3010\u6d4b\u8bd5\u3011 oaid Md5 \u5408\u6cd5");
        deviceDTO = DeviceDTO.builder().oaid_md5("d41d8cd98f00b204e9800998ecf84273").build();
        DeviceIdUtils.checkAndGenerateDeviceId(deviceDTO);
        System.out.println(deviceDTO);
        System.out.println("\u3010\u6d4b\u8bd5\u3011 deviceId \u5408\u6cd5\uff1a d41d8cd98f00b204e9800998ecf84274");
        deviceDTO = DeviceDTO.builder().deviceId("d41d8cd98f00b204e9800998ecf84274").build();
        DeviceIdUtils.checkAndGenerateDeviceId(deviceDTO);
        System.out.println(deviceDTO);
        System.out.println("\u3010\u6d4b\u8bd5\u3011 imei \u4f20\u9519\u4e86\u4f20\u4e86MD5\uff1a d41d8cd98f00b204e9800998ecf84275");
        deviceDTO = DeviceDTO.builder().imei("d41d8cd98f00b204e9800998ecf84275").build();
        DeviceIdUtils.checkAndGenerateDeviceId(deviceDTO);
        System.out.println(deviceDTO);
        System.out.println("\u3010\u6d4b\u8bd5\u3011 imeiMd5 \u4e0d\u5408\u6cd5\uff1a cfcd208495d565ef66e7dff9f98764da");
        deviceDTO = DeviceDTO.builder().imei_md5(DeviceMd5BlackEnum.ERROR_1.getDeviceMd5()).deviceType(DeviceTypeEnum.IMEI.getCode()).build();
        DeviceIdUtils.checkAndGenerateDeviceId(deviceDTO);
        System.out.println(deviceDTO);
        System.out.println("\u3010\u6d4b\u8bd5\u3011 deviceId \u4e0d\u5408\u6cd5\uff0coaidMd5 \u5408\u6cd5\uff1a d41d8cd98f00b204e9800998ecf84273");
        deviceDTO = DeviceDTO.builder().deviceId(DeviceMd5BlackEnum.ERROR_1.getDeviceMd5()).oaid_md5("d41d8cd98f00b204e9800998ecf84273").build();
        DeviceIdUtils.checkAndGenerateDeviceId(deviceDTO);
        System.out.println(deviceDTO);
        System.out.println("\u3010\u6d4b\u8bd5\u3011 deviceId \u4e0d\u5408\u6cd5\uff0cimei \u4f20\u9519\u6210md5\uff1a d41d8cd98f00b204e9800998ecf84273");
        deviceDTO = DeviceDTO.builder().deviceId(DeviceMd5BlackEnum.ERROR_1.getDeviceMd5()).imei("d41d8cd98f00b204e9800998ecf84273").build();
        DeviceIdUtils.checkAndGenerateDeviceId(deviceDTO);
        System.out.println(deviceDTO);
        System.out.println("\u3010\u6d4b\u8bd5\u3011 \u91c7\u96c6imei\uff0cimei\u4f20\u9519\uff1a cfcd208495d565ef66e7dff9f98764da");
        deviceDTO = DeviceDTO.builder().imei_md5(DeviceMd5BlackEnum.ERROR_1.getDeviceMd5()).deviceType(DeviceTypeEnum.IMEI.getCode()).build();
        DeviceIdUtils.checkAndGenerateDeviceId(deviceDTO);
        System.out.println(deviceDTO);
        System.out.println("\u3010\u6d4b\u8bd5\u3011 \u91c7\u96c6 IDFA\uff0cIDFA \u4f20\u9519\uff1a cfcd208495d565ef66e7dff9f98764da");
        deviceDTO = DeviceDTO.builder().idfa("cfcd208495d565ef66e7dff9f98764da").deviceType(DeviceTypeEnum.IDFA.getCode()).build();
        DeviceIdUtils.checkAndGenerateDeviceId(deviceDTO);
        System.out.println(deviceDTO);
    }
}

