/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.tools.deviceid;

import cn.tuia.tools.deviceid.DeviceMd5BlackEnum;
import cn.tuia.tools.deviceid.DeviceTypeEnum;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class LegalMd5Factory {
    private static Pattern PATTERN_IMEI_ONE = Pattern.compile("\\d{15}$");
    private static Pattern PATTERN_IMEI_TWO = Pattern.compile("^(A|a)\\d{14}$");
    private static Pattern PATTERN_IDFA = Pattern.compile("^([0-9a-zA-Z]{1,})(([/\\s-][0-9a-zA-Z]{1,}){4})$");
    private static Pattern PATTERN_IDFA_LENGTH = Pattern.compile("^.{36}$");
    private static Pattern PATTERN_MD5_LOWER_CASE = Pattern.compile("^([0-9a-f]{32})$");

    public static boolean checkLegalMd5(String str, DeviceTypeEnum typeEnum) {
        if (StringUtils.isEmpty((CharSequence)str) || null == typeEnum) {
            return false;
        }
        if (typeEnum.equals((Object)DeviceTypeEnum.IMEI)) {
            return LegalMd5Factory.isImei(str);
        }
        if (typeEnum.equals((Object)DeviceTypeEnum.IDFA)) {
            return LegalMd5Factory.isIdfa(str);
        }
        if (typeEnum.equals((Object)DeviceTypeEnum.OAID)) {
            return LegalMd5Factory.isOaid(str);
        }
        if (typeEnum.equals((Object)DeviceTypeEnum.DEVICE_ID)) {
            return LegalMd5Factory.isLowerCase32Md5(str);
        }
        return false;
    }

    public static boolean isLowerCase32Md5(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        boolean matches = PATTERN_MD5_LOWER_CASE.matcher(str.trim()).matches();
        boolean unLegalFlag = DeviceMd5BlackEnum.checkDeviceIdLegal(str);
        return unLegalFlag && matches;
    }

    private static boolean isImei(String imei) {
        if (StringUtils.isBlank((CharSequence)imei)) {
            return false;
        }
        return PATTERN_IMEI_ONE.matcher(imei.trim()).matches() || PATTERN_IMEI_TWO.matcher(imei.trim()).matches();
    }

    private static boolean isIdfa(String idfa) {
        if (StringUtils.isBlank((CharSequence)idfa)) {
            return false;
        }
        return PATTERN_IDFA.matcher(idfa).matches() && PATTERN_IDFA_LENGTH.matcher(idfa).matches();
    }

    private static boolean isOaid(String oaid) {
        if (StringUtils.isBlank((CharSequence)oaid)) {
            return false;
        }
        return oaid.length() >= 8;
    }
}

