package cn.tuia.tools.deviceid;

import java.util.HashSet;
import java.util.Set;

/**
 * md5后有问题的设备号
 */
public enum DeviceMd5BlackEnum {
    ERROR_1("cfcd208495d565ef66e7dff9f98764da", "0"),
    ERROR_2("9f89c84a559f573636a47ff8daed0d33", "00000000-0000-0000-0000-000000000000"),
    ERROR_3("5284047f4ffb4e04824a2fd1d1f0cd62", "000000000000000"),
    ERROR_4("37a6259cc0c1dae299a7866489dff0bd", "null"),
    ERROR_5("d41d8cd98f00b204e9800998ecf8427e", ""),
    Error_99("ad921d60486366258809553a3db49a4a", "unknown");

    /**
     * md5之后的设备号
     */
    private String deviceMd5;

    private String deviceOrigin;

    /**
     * 存储结构改成Hash，增加读取速度
     */
    private static Set<String> DeviceMd5BlackSet = new HashSet<>();

    static {
        DeviceMd5BlackEnum[] values = DeviceMd5BlackEnum.values();
        for (DeviceMd5BlackEnum value : values) {
            DeviceMd5BlackSet.add(value.getDeviceMd5());
        }
    }


    DeviceMd5BlackEnum(String deviceMd5, String deviceOrigin) {
        this.deviceMd5 = deviceMd5;
        this.deviceOrigin = deviceOrigin;
    }

    /**
     * 不开发获取
     * @return
     */
    public String getDeviceMd5() {
        return deviceMd5;
    }

    private String getDeviceOrigin() {
        return deviceOrigin;
    }

    /**
     * 是否命中黑名单枚举，命中返回Null----------------------------------------------------------
     */
    public static boolean checkDeviceIdLegal(String deviceMd5Str) {
        if (null == deviceMd5Str || "".equals(deviceMd5Str)) {
            return false;
        }

        // 设备号包含非法字符
        if (DeviceMd5BlackSet.contains(deviceMd5Str)) {
            return false;
        }
        return true;

    }

//    public static void main(String[] args) {
//        System.out.println("测试");
//        System.out.println(checkDeviceIdLegal("37a6259cc0c1dae299a7866489dff0bd"));
//        System.out.println(checkDeviceIdLegal("1"));
//    }


}
