package cn.tuia.tools.deviceid;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

/**
 * @Description:
 * @author: 阿海
 * @create: 2020-06-09 09:50
 */
public enum DeviceTypeEnum {
    /**
     * 1010用于替换自动生成的uuid
     * 不能是imei这种字符，32位MD5只包含了0~9和a~f
     */
    IMEI(1, "1010"),
    IDFA(2, "1020"),
    OAID(3, "1011"),
    // 合法的deviceId是md5小写32位的
    DEVICE_ID(4, "1030"),
    UUID(5, "1040"),
    THIRD_USER(7, "1050"),
    THIRD_DEVICE(8, "1051"),
    UNKNOWN(6, "1090");

    DeviceTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private Integer code;

    private String desc;

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 根据code检索内容
     *
     * @param code
     * @return
     */
    public static DeviceTypeEnum seekValue(Integer code) {
        if (null == code) {
            return UNKNOWN;
        }
        Optional<DeviceTypeEnum> result = Arrays.stream(DeviceTypeEnum.values())
                .filter(target -> (Objects.nonNull(target) && target.code.equals(code))).findFirst();
        return result.orElse(UNKNOWN);
    }
}
