package cn.tuia.tools.deviceid;

import org.apache.commons.lang3.StringUtils;

import java.util.regex.Pattern;

/**
 * @Description:
 * @author: 阿海
 * @create: 2020-06-10 17:41
 * IMEI：351710058880864
 * IDFA: CCD6E1CD-8C4B-40CB-8A62-4BBC7AFE07D6
 * oaid：351710058880864
 *
 */
public class LegalMd5Factory {

    private static Pattern PATTERN_IMEI_ONE = Pattern.compile("\\d{15}$");

    private static Pattern PATTERN_IMEI_TWO = Pattern.compile("^(A|a)\\d{14}$");

    private static Pattern PATTERN_IDFA = Pattern.compile("^([0-9a-zA-Z]{1,})(([/\\s-][0-9a-zA-Z]{1,}){4})$");

    private static Pattern PATTERN_IDFA_LENGTH = Pattern.compile("^.{36}$");

    private static Pattern PATTERN_MD5_LOWER_CASE = Pattern.compile("^([0-9a-f]{32})$");

    /**
     * 合法性校验
     * @param str
     * @return
     */
    public static boolean checkLegalMd5(String str, DeviceTypeEnum typeEnum) {
        if (StringUtils.isEmpty(str) || null == typeEnum) {
            return false;
        }
        if (typeEnum.equals(DeviceTypeEnum.IMEI)) {
            return isImei(str);
        }
        if (typeEnum.equals(DeviceTypeEnum.IDFA)) {
            return isIdfa(str);
        }
        if (typeEnum.equals(DeviceTypeEnum.OAID)) {
            return isOaid(str);
        }
        if (typeEnum.equals(DeviceTypeEnum.DEVICE_ID)) {
            return isLowerCase32Md5(str);
        }
        return false;
    }

    /**
     * 合法性校验-----------------------------------------------------------------------
     * 是否小写32位MD5加密字符串
     *
     * @param str
     * @return
     */
    public static boolean isLowerCase32Md5(String str) {
        if (StringUtils.isBlank(str)) {
            return false;
        }
        boolean matches = PATTERN_MD5_LOWER_CASE.matcher(str.trim()).matches();
        // 黑名单设备号
        boolean unLegalFlag = DeviceMd5BlackEnum.checkDeviceIdLegal(str);
        return unLegalFlag && matches;
    }

    /**
     * 入参是否真实imei
     * IMEI：351710058880864
     * 1、长度是否等于15
     * 2、是否纯数字 || 是否A+14位纯数字
     */
    private static boolean isImei(String imei) {
        if (StringUtils.isBlank(imei)) {
            return false;
        }

        return PATTERN_IMEI_ONE.matcher(imei.trim()).matches() || PATTERN_IMEI_TWO.matcher(imei.trim()).matches();
    }

    /**
     * 入参是否真实idfa
     * IDFA: CCD6E1CD-8C4B-40CB-8A62-4BBC7AFE07D6
     * 1、直接正则匹配
     */
    private static boolean isIdfa(String idfa) {
        if (StringUtils.isBlank(idfa)) {
            return false;
        }
        return PATTERN_IDFA.matcher(idfa).matches() && PATTERN_IDFA_LENGTH.matcher(idfa).matches();
    }

    /**
     * 入参是否真实oaid
     * todo 规则需要完善
     */
    private static boolean isOaid(String oaid) {
        if (StringUtils.isBlank(oaid)) {
            return false;
        }
        if (oaid.length() < 8) {
            return false;
        }
        return true;
    }

}
