package cn.tuia.tools.toolsadx;

import cn.tuia.tools.constant.StringConstant;

import java.util.concurrent.atomic.AtomicLong;

/**
 * 〈一句话功能简述〉<br>
 * Description: adx出价申请工具类
 *
 * @author hillchen
 * @create 2019/2/26 13:58
 */
public class AdxBidUtils {

    private static AtomicLong ADX_RID_SEQ = new AtomicLong(); //自增id，线程安全
    private static final long START_TIME_STAMPT = System.currentTimeMillis();//服务启动时间戳

    private AdxBidUtils() {
    }

    /**
     * 根据流量（设备id）生成全局唯一的id
     *
     * @param imei
     * @return
     */
    public static String createAdxRid(String imei) {
        return imei + StringConstant.SPLIT_TAG + Long.toString(START_TIME_STAMPT, Character.MAX_RADIX)
                + StringConstant.SPLIT_TAG + ADX_RID_SEQ.incrementAndGet();
    }


}