/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.tools.deviceid.v2;

import cn.tuia.tools.deviceid.v2.DeviceInfo;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class MacroUtils {
    public static final String IMEI_MACRO = "tu_a";
    public static final String IDFA_MACRO = "tu_b";
    public static final String OAID_MACRO = "tu_c";

    public static DeviceInfo getDeviceInfoByRequest(HttpServletRequest request) {
        Map<String, String> allRequestParam = MacroUtils.getAllRequestParam(request);
        return MacroUtils.getDeviceInfoByMacroMap(allRequestParam);
    }

    public static DeviceInfo getDeviceInfoByMacroMap(Map<String, String> macroParam) {
        String imei = MacroUtils.findAvailableMacro(macroParam, IMEI_MACRO);
        String idfa = MacroUtils.findAvailableMacro(macroParam, IDFA_MACRO);
        String oaid = MacroUtils.findAvailableMacro(macroParam, OAID_MACRO);
        System.err.println("imei:" + imei + "       idfa:" + idfa + "       oaid:" + oaid);
        return new DeviceInfo(imei, idfa, oaid);
    }

    public static DeviceInfo getDeviceInfoByMacroStr(String macroParam) {
        if (StringUtils.isEmpty((String)macroParam)) {
            return new DeviceInfo("", "", "");
        }
        if (!(macroParam.contains(IMEI_MACRO) || macroParam.contains(IDFA_MACRO) || macroParam.contains(OAID_MACRO))) {
            return new DeviceInfo("", "", "");
        }
        String trimMacroPattern = MacroUtils.trimBothEndsChars(macroParam, "&");
        String[] params = trimMacroPattern.split("&");
        HashMap<String, String> deviceParam = new HashMap<String, String>();
        Arrays.asList(params).stream().forEach(e -> {
            String[] kv = e.split("=");
            if (kv.length == 2) {
                deviceParam.put(kv[0], kv[1]);
            }
        });
        return MacroUtils.getDeviceInfoByMacroMap(deviceParam);
    }

    private static String trimBothEndsChars(String srcStr, String splitter) {
        String regex = "^" + splitter + "*|" + splitter + "*$";
        return srcStr.replaceAll(regex, "");
    }

    private static String findAvailableMacro(Map<String, String> macroParam, String startWith) {
        String macro;
        String macroValue;
        TreeSet macroSet = new TreeSet(macroParam.keySet().stream().filter(e -> e.startsWith(startWith)).collect(Collectors.toSet()));
        System.err.println(macroSet);
        String availableMacro = "";
        Iterator iterator = macroSet.iterator();
        while (iterator.hasNext() && (MacroUtils.isBlackDevice(macroValue = macroParam.get(macro = (String)iterator.next())) || !StringUtils.isNotEmpty((String)(availableMacro = macroValue)))) {
        }
        return availableMacro;
    }

    private static final boolean isBlackDevice(String macro) {
        if (StringUtils.isBlank((String)macro)) {
            return false;
        }
        return macro.startsWith("__") && macro.endsWith("__");
    }

    private static Map<String, String> getAllRequestParam(HttpServletRequest request) {
        HashMap<String, String> res = new HashMap<String, String>();
        Enumeration temp = request.getParameterNames();
        if (null != temp) {
            while (temp.hasMoreElements()) {
                String en = (String)temp.nextElement();
                String value = request.getParameter(en);
                res.put(en, value);
                if (null != res.get(en) && !StringUtils.isEmpty((String)((String)res.get(en)))) continue;
                res.remove(en);
            }
        }
        return res;
    }

    public static void main(String[] args) {
    }
}

