package cn.tuia.tools.deviceid;

import java.util.HashSet;
import java.util.Set;

/**
 * md5后有问题的设备号
 * （1）媒体的行为：传设备号、不传设备号（就当新用户，可以利用ip、流量特征，只是不用dmp）
 * （2）传设备号：传正确的、瞎传的
 * （3）瞎传的我们每天将近有500万的pv是同一个用户，这个用户几乎所有的流量都是浪费的
 * （4）因为我们重复曝光过滤，优质的广告不会给这500万的用户
 */
public enum DeviceMd5BlackEnum {
    ERROR_1("cfcd208495d565ef66e7dff9f98764da", "0"),
    ERROR_2("9f89c84a559f573636a47ff8daed0d33", "00000000-0000-0000-0000-000000000000"),
    ERROR_3("5284047f4ffb4e04824a2fd1d1f0cd62", "000000000000000"),
    ERROR_4("37a6259cc0c1dae299a7866489dff0bd", "null"),
    ERROR_5("d41d8cd98f00b204e9800998ecf8427e", ""),
    ERROR_6("1e4a1b03d1b6cd8a174a826f76e009f4","0000000000000000"),
    ERROR_7("696b031073e74bf2cb98e5ef201d4aa3","UNKNOWN"),
    ERROR_8("6c3e226b4d4795d518ab341b0824ec29","NULL"),
    ERROR_9("5e543256c480ac577d30f76f9120eb74","undefined"),
    ERROR_10("0db45d2a4141101bdfe48e3314cfbca3","UNDEFINED"),
    Error_99("ad921d60486366258809553a3db49a4a", "unknown");

    /**
     * md5之后的设备号
     */
    private String deviceMd5;

    private String deviceOrigin;

    /**
     * 存储结构改成Hash，增加读取速度
     */
    private static Set<String> DeviceMd5BlackSet = new HashSet<>();

    private static Set<String> DeviceBlackSet = new HashSet<>();

    static {
        DeviceMd5BlackEnum[] values = DeviceMd5BlackEnum.values();
        for (DeviceMd5BlackEnum value : values) {
            DeviceMd5BlackSet.add(value.getDeviceMd5());
        }
    }

    static {
        DeviceMd5BlackEnum[] values = DeviceMd5BlackEnum.values();
        for (DeviceMd5BlackEnum value : values) {
            DeviceBlackSet.add(value.getDeviceOrigin());
        }
    }


    DeviceMd5BlackEnum(String deviceMd5, String deviceOrigin) {
        this.deviceMd5 = deviceMd5;
        this.deviceOrigin = deviceOrigin;
    }

    /**
     * 不开发获取
     * @return
     */
    public String getDeviceMd5() {
        return deviceMd5;
    }

    private String getDeviceOrigin() {
        return deviceOrigin;
    }

    /**
     * 是否命中黑名单枚举，命中返回Null----------------------------------------------------------
     */
    public static boolean checkDeviceIdLegal(String deviceMd5Str) {
        if (null == deviceMd5Str || "".equals(deviceMd5Str)) {
            return false;
        }

        // 设备号包含非法字符
        if (DeviceMd5BlackSet.contains(deviceMd5Str)) {
            return false;
        }
        return true;

    }

    public static boolean checkDeviceIdBlack(String deviceStr) {
        if (null == deviceStr || "".equals(deviceStr)) {
            return false;
        }

        // 设备号包含非法字符
        if (DeviceBlackSet.contains(deviceStr)) {
            return false;
        }
        return true;

    }

//    public static void main(String[] args) {
//        System.out.println("测试");
//        System.out.println(checkDeviceIdLegal("37a6259cc0c1dae299a7866489dff0bd"));
//        System.out.println(checkDeviceIdLegal("1"));
//    }


}
