package cn.tuia.tools.deviceid.v2;

import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

public class MacroUtils {
    /**
     * tu_a表示：imei/imei密文（兼容老的匿名参数）
     */
    public static final String IMEI_MACRO = "tu_a";
    /**
     * 新匿名参数 uk_a表示：imei/imei密文
     */
    public static final String IMEI_MACRO_NEW = "uk_a";
    /**
     * tu_b表示：idfa/idfa密文（兼容老的匿名参数）
     */
    public static final String IDFA_MACRO = "tu_b";
    /**
     * 新匿名参数 uk_b表示：idfa/idfa密文
     */
    public static final String IDFA_MACRO_NEW = "uk_b";
    /**
     * tu_c表示：oaid/oaid密文（兼容老的匿名参数）
     */
    public static final String OAID_MACRO = "tu_c";
    /**
     * 新匿名参数 uk_c表示：oaid/oaid密文
     */
    public static final String OAID_MACRO_NEW = "uk_c";

    private static  final List<String> MACRO_LIST = Lists.newArrayList(IMEI_MACRO, IMEI_MACRO_NEW, IDFA_MACRO, IDFA_MACRO_NEW, OAID_MACRO, OAID_MACRO_NEW);


//    public static DeviceInfo getDeviceInfoByRequest(HttpServletRequest request) {
//        Map<String, String> allRequestParam = getAllRequestParam(request);
//        return getDeviceInfoByMacroMap(allRequestParam);
//    }


    public static DeviceInfo getDeviceInfoByMacroMap(Map<String, String> macroParam) {
        String imei = findAvailableMacro(macroParam, Lists.newArrayList(IMEI_MACRO, IMEI_MACRO_NEW));
        String idfa = findAvailableMacro(macroParam, Lists.newArrayList(IDFA_MACRO, IDFA_MACRO_NEW));
        String oaid = findAvailableMacro(macroParam, Lists.newArrayList(OAID_MACRO, OAID_MACRO_NEW));
        return new DeviceInfo(imei, idfa, oaid);
    }

    /**
     * 通过startWithList 匹配查找对应的入参value值
     * @param macroParam 入参map
     * @param startWithList 要匹配参数的前缀
     * @return 对应的参数值
     */
    public static String findAvailableMacro(Map<String, String> macroParam, List<String> startWithList){
        String availableMacro = StringUtils.EMPTY;
        if(CollectionUtils.isEmpty(startWithList)){
            return availableMacro;
        }
        for (String startWith : startWithList){
            availableMacro = findAvailableMacro(macroParam, startWith);
            if (StringUtils.isNotEmpty(availableMacro)){
                break;
            }
        }
        return availableMacro;
    }

    public static DeviceInfo getDeviceInfoByMacroStr(String macroParam) {
        if (StringUtils.isEmpty(macroParam)) {
            return new DeviceInfo("", "", "");
        }
        if (!containsMacroStr(macroParam)) {
            return new DeviceInfo("", "", "");
        }

        String trimMacroPattern = trimBothEndsChars(macroParam, "&");
        String[] params = trimMacroPattern.split("&");
        Map<String, String> deviceParam = new HashMap<>();
        Arrays.asList(params).stream().forEach(e -> {
            String[] kv = e.split("=");
            if (kv.length == 2) {
                deviceParam.put(kv[0], kv[1]);
            }

        });
        return getDeviceInfoByMacroMap(deviceParam);
    }

    /**
     * 判断入参是否包含 宏密文
     * @param macroParam
     * @return
     */
    private static boolean containsMacroStr(String macroParam){
        for (String  macroStr : MACRO_LIST){
            if(macroParam.contains(macroStr)){
                return true;
            }
        }
        return false;
    }



    /**
     * 去掉首尾特殊字符
     *
     * @param srcStr
     * @param splitter
     * @return
     */
    private static String trimBothEndsChars(String srcStr, String splitter) {
        String regex = "^" + splitter + "*|" + splitter + "*$";
        return srcStr.replaceAll(regex, "");
    }

    /**
     * 找到媒体真实对接的imei、idfa、oaid
     *
     * @param macroParam
     * @return
     */
    public static String findAvailableMacro(Map<String, String> macroParam, String startWith) {
        TreeSet<String> macroSet = new TreeSet<>(
                macroParam.keySet().stream()
                        .filter(e -> e.startsWith(startWith))
                        .collect(Collectors.toSet())
        );
        String availableMacro = StringUtils.EMPTY;
        for (String macro : macroSet) {
            String macroValue = macroParam.get(macro);
            if (isBlackDevice(macroValue)) {
                continue;
            }
            availableMacro = macroValue;
            if (StringUtils.isNotEmpty(availableMacro)) {
                break;
            }
        }
        return availableMacro;
    }

    /**
     * 过滤 “__xxx__”
     *
     * @param macro
     * @return
     */
    private static final boolean isBlackDevice(String macro) {
        if (StringUtils.isBlank(macro)) {
            return false;
        }
        if (macro.startsWith("__") && macro.endsWith("__")) {
            return true;
        }
        return false;
    }


//    public static void main(String[] args) {
//        getDeviceInfoByMacro("&tu_c3=XXX3&tu_a1=__123321__&tu_b3=HHH9&tu_a2=__23234__&tu_a3=cccqqq&tu_c2=__XXX2__&tu_b1=__HHH__&tu_b2=__HHH2__&tu_c1=XXX");
//        getDeviceInfoByMacro("&tu_a1=__IMEI__&tu_a2=012345678912345&tu_a3=__MUID__");
//        getDeviceInfoByMacro("&tu_a2=012345678912345");
//        getDeviceInfoByMacro("&tu_a2=");
//        getDeviceInfoByMacro("&&");
//        getDeviceInfoByMacro(null);
//    }
}
