package cn.tuia.tools.deviceid;

import lombok.Builder;
import lombok.Data;
import lombok.ToString;

/**
 * @Description:
 * @author: 阿海
 * @create: 2020-06-09 09:53
 */
@Builder
@ToString
public class DeviceDTO {

    /**
     * 站内设备号，小写32为_md5
     */
    private String deviceId;

    /**
     * 设备号类型 {@link DeviceTypeEnum}
     */

    private Integer deviceType;
    /**
     * 站外传入是否合法，true合法
     */

    private Boolean legalFlag;

    /**
     * 缓存的uuid，应用场景：sdk客户端生成
     */
    private String tcid;

    /**
     * 站外入参
     */
    private String imei;
    private String idfa;
    private String oaid;

    /**
     * 驼峰写成了下划线，方便日志处理
     */
    private String imei_md5;
    private String idfa_md5;
    private String oaid_md5;

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public Integer getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(Integer deviceType) {
        this.deviceType = deviceType;
    }

    public Boolean getLegalFlag() {
        return legalFlag;
    }

    public void setLegalFlag(Boolean legalFlag) {
        this.legalFlag = legalFlag;
    }

    public String getTcid() {
        return tcid;
    }

    public void setTcid(String tcid) {
        this.tcid = tcid;
    }

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public String getIdfa() {
        return idfa;
    }

    public void setIdfa(String idfa) {
        this.idfa = idfa;
    }

    public String getOaid() {
        return oaid;
    }

    public void setOaid(String oaid) {
        this.oaid = oaid;
    }

    public String getImei_md5() {
        return imei_md5;
    }

    public void setImei_md5(String imei_md5) {
        this.imei_md5 = imei_md5;
    }

    public String getIdfa_md5() {
        return idfa_md5;
    }

    public void setIdfa_md5(String idfa_md5) {
        this.idfa_md5 = idfa_md5;
    }

    public String getOaid_md5() {
        return oaid_md5;
    }

    public void setOaid_md5(String oaid_md5) {
        this.oaid_md5 = oaid_md5;
    }

}

/**
 * 临时使用对象
 */
@Data
class TempObjectMd5 {
    private String str;
    private String strMd5;

    public TempObjectMd5(String str, String strMd5) {
        this.str = str;
        this.strMd5 = strMd5;
    }
}