package cn.tuia.tools.macro;

import cn.com.duiba.wolf.utils.UrlUtils2;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author: tangzhen@duiba.com.cn
 * @date:2021/5/8
 * @description: 宏替换
 **/
public class MacroReplaceUrlUtils {

    /**
     * 简单宏替换，不支持链接二次替换
     * 无macroFlag字段，是否替换业务自行判断
     *
     * 宏替换键值一对一，不支持一对多
     *
     * @return 替换后url
     */
    public static String repalceCallback(String callbackUrl, Map<String, String> macroMap, JSONObject data){

        if (StringUtils.isBlank(callbackUrl) || MapUtils.isEmpty(macroMap) || null == data) {
            return callbackUrl;
        }

        // 1 骨肉分离 将接口与参数分离
        String extractUrl = UrlUtils2.extractUrl(callbackUrl);

        Map<String, String> map = UrlUtils2.extractUrlParamsFromUrl(callbackUrl);

        // 2 宏替换
        Map<String, String> appendParams = new HashMap<>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            // 2.1 非宏替换字段
            if (!entry.getValue().startsWith("__")) {
                appendParams.put(entry.getKey(), entry.getValue());
                continue;
            }
            // 2.2 宏替换字段
            String paramKey = macroMap.get(entry.getValue());

            // 2.3 宏字段不存在
            if (StringUtils.isBlank(paramKey)) {
                continue;
            }
            String obj = data.getString(paramKey);

            // 2.4 需替换值不存在
            if (Objects.isNull(obj)) {
                continue;
            }
            appendParams.put(entry.getKey(), obj);
        }
        // 3 重新拼接并返回
        return UrlUtils2.appendParams(extractUrl, appendParams);
    }
}
