/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.tools.deviceid;

import cn.tuia.tools.deviceid.DeviceDTO;
import cn.tuia.tools.deviceid.DeviceTypeEnum;
import cn.tuia.tools.deviceid.LegalMd5Factory;
import cn.tuia.tools.deviceid.TempObjectMd5;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public class DeviceIdUtilService {
    public static void checkAndGenerateDeviceId(DeviceDTO deviceDTO) {
        DeviceIdUtilService.transferMd5DTO(deviceDTO);
        String deviceId = deviceDTO.getDeviceId();
        if (StringUtils.isNotEmpty((String)deviceId) && LegalMd5Factory.checkLegalMd5(deviceId, DeviceTypeEnum.DEVICE_ID)) {
            deviceDTO.setLegalFlag(true);
            deviceDTO.setDeviceType(DeviceTypeEnum.DEVICE_ID.getCode());
            return;
        }
        Integer deviceType = DeviceTypeEnum.UNKNOWN.getCode();
        if (StringUtils.isNotEmpty((String)deviceDTO.getImei_md5())) {
            deviceType = DeviceTypeEnum.IMEI.getCode();
            deviceId = deviceDTO.getImei_md5();
        } else if (StringUtils.isNotEmpty((String)deviceDTO.getIdfa_md5())) {
            deviceType = DeviceTypeEnum.IDFA.getCode();
            deviceId = deviceDTO.getIdfa_md5();
        } else if (StringUtils.isNotEmpty((String)deviceDTO.getOaid_md5())) {
            deviceType = DeviceTypeEnum.OAID.getCode();
            deviceId = deviceDTO.getOaid_md5();
        }
        if (!DeviceTypeEnum.UNKNOWN.getCode().equals(deviceType)) {
            deviceDTO.setLegalFlag(true);
            deviceDTO.setDeviceId(deviceId);
            deviceDTO.setDeviceType(deviceType);
            return;
        }
        deviceType = deviceDTO.getDeviceType();
        DeviceTypeEnum deviceTypeEnum = DeviceTypeEnum.seekValue(deviceType);
        String desc = deviceTypeEnum.getDesc();
        deviceId = DeviceIdUtilService.getUUIDAndMd5(desc);
        deviceDTO.setLegalFlag(false);
        deviceDTO.setDeviceType(deviceTypeEnum.getCode());
        deviceDTO.setDeviceId(deviceId);
    }

    private static void transferMd5DTO(DeviceDTO deviceDTO) {
        TempObjectMd5 objectMd51 = new TempObjectMd5(deviceDTO.getImei(), deviceDTO.getImei_md5());
        DeviceIdUtilService.checkLegalMd5(objectMd51, DeviceTypeEnum.IMEI);
        deviceDTO.setImei(objectMd51.getStr());
        deviceDTO.setImei_md5(objectMd51.getStrMd5());
        TempObjectMd5 objectMd52 = new TempObjectMd5(deviceDTO.getIdfa(), deviceDTO.getIdfa_md5());
        DeviceIdUtilService.checkLegalMd5(objectMd52, DeviceTypeEnum.IDFA);
        deviceDTO.setIdfa(objectMd52.getStr());
        deviceDTO.setIdfa_md5(objectMd52.getStrMd5());
        TempObjectMd5 objectMd53 = new TempObjectMd5(deviceDTO.getOaid(), deviceDTO.getOaid_md5());
        DeviceIdUtilService.checkLegalMd5(objectMd53, DeviceTypeEnum.OAID);
        deviceDTO.setOaid(objectMd53.getStr());
        deviceDTO.setOaid_md5(objectMd53.getStrMd5());
    }

    private static void checkLegalMd5(TempObjectMd5 objectMd5, DeviceTypeEnum typeEnum) {
        String strMd5;
        String str = objectMd5.getStr();
        if (LegalMd5Factory.checkLegalMd5(str, typeEnum)) {
            objectMd5.setStrMd5(DigestUtils.md5Hex((String)str));
            return;
        }
        String imeiMd5Temp = "";
        if (LegalMd5Factory.isLowerCase32Md5(str)) {
            imeiMd5Temp = str;
        }
        if (StringUtils.isEmpty((String)(strMd5 = objectMd5.getStrMd5()))) {
            return;
        }
        if (!LegalMd5Factory.isLowerCase32Md5(strMd5)) {
            objectMd5.setStrMd5(imeiMd5Temp);
        }
    }

    public static String getUUIDAndMd5(String desc) {
        if (StringUtils.isEmpty((String)desc) || desc.length() > 4) {
            desc = DeviceTypeEnum.UNKNOWN.getDesc();
        }
        int length = desc.length();
        String uuid = UUID.randomUUID().toString() + System.currentTimeMillis();
        uuid = DigestUtils.md5Hex((String)uuid);
        uuid = desc + uuid.substring(length, uuid.length());
        return uuid;
    }
}

