/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.tools.deviceid;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public enum DeviceTypeEnum {
    IMEI(1, "1010"),
    IDFA(2, "1020"),
    OAID(3, "1011"),
    DEVICE_ID(4, "1030"),
    UUID(5, "1040"),
    THIRD_USER(7, "1050"),
    THIRD_DEVICE(8, "1051"),
    SDK_TEST(9, "1060"),
    UNKNOWN(99, "1090");

    private Integer code;
    private String desc;

    private DeviceTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public static DeviceTypeEnum seekValue(Integer code) {
        if (null == code) {
            return UNKNOWN;
        }
        Optional<DeviceTypeEnum> result = Arrays.stream(DeviceTypeEnum.values()).filter(target -> Objects.nonNull(target) && target.code.equals(code)).findFirst();
        return result.orElse(UNKNOWN);
    }
}

