/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.tools.deviceid.v2;

import cn.tuia.tools.deviceid.v2.DeviceType;
import cn.tuia.tools.deviceid.v2.ImeiAndIdfaUtils;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class DeviceInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String imei;
    private String idfa;
    private String oaid;
    private Boolean isEncrypt;
    private DeviceType deviceType;
    private String deviceUniqueId;
    private String imeiMd5;
    private String idfaMd5;
    private String oaidMd5;

    public DeviceInfo() {
    }

    public DeviceInfo(String imei, String idfa, String oaid) {
        this.imei = imei;
        this.idfa = idfa;
        this.oaid = oaid;
        this.resetInitValue();
    }

    public DeviceInfo(String imei, String idfa, String oaid, Map<String, String> extBlack) {
        this.imei = imei;
        this.idfa = idfa;
        this.oaid = oaid;
        this.resetInitValue(extBlack);
    }

    public String getImei() {
        return this.imei;
    }

    public String getIdfa() {
        return this.idfa;
    }

    public String getOaid() {
        return this.oaid;
    }

    public Boolean getEncrypt() {
        return this.isEncrypt;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public String getDeviceUniqueId() {
        return this.deviceUniqueId;
    }

    public String getImeiMd5() {
        return this.imeiMd5;
    }

    public String getIdfaMd5() {
        return this.idfaMd5;
    }

    public String getOaidMd5() {
        return this.oaidMd5;
    }

    private DeviceInfo deviceUniqueId(String deviceUniqueId) {
        this.deviceUniqueId = deviceUniqueId;
        return this;
    }

    private DeviceInfo deviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    private DeviceInfo encrypt(Boolean encrypt) {
        this.isEncrypt = encrypt;
        return this;
    }

    private DeviceInfo imeiMd5(String imeiMd5) {
        this.imeiMd5 = imeiMd5;
        return this;
    }

    private DeviceInfo idfaMd5(String idfaMd5) {
        this.idfaMd5 = idfaMd5;
        return this;
    }

    private DeviceInfo oaidMd5(String oaidMd5) {
        this.oaidMd5 = oaidMd5;
        return this;
    }

    public boolean isNull() {
        return StringUtils.isBlank((CharSequence)this.imei) && StringUtils.isBlank((CharSequence)this.idfa) && StringUtils.isBlank((CharSequence)this.oaid);
    }

    public boolean isNullAfterBuild() {
        return this.deviceType == null;
    }

    public DeviceInfo build(String isEncrypt) {
        if (StringUtils.isBlank((CharSequence)this.imei) && StringUtils.isBlank((CharSequence)this.idfa) && StringUtils.isBlank((CharSequence)this.oaid)) {
            return this;
        }
        if (StringUtils.isBlank((CharSequence)isEncrypt)) {
            isEncrypt = "-1";
        }
        switch (isEncrypt) {
            case "1": {
                this.setIfEncryptTrue();
                break;
            }
            case "0": {
                this.setIfEncryptFalse();
                break;
            }
            default: {
                this.setIfEncryptDefault();
            }
        }
        return this;
    }

    private void setIfEncryptFalse() {
        if (ImeiAndIdfaUtils.isIdfa(this.idfa)) {
            String idfaMd5 = DigestUtils.md5Hex((String)this.idfa);
            this.deviceType(DeviceType.IDFA).idfaMd5(idfaMd5).deviceUniqueId(idfaMd5).encrypt(Boolean.FALSE);
        }
        if (ImeiAndIdfaUtils.isImei(this.imei)) {
            String imeiMd5 = DigestUtils.md5Hex((String)this.imei);
            this.deviceType(DeviceType.IMEI).imeiMd5(imeiMd5).deviceUniqueId(imeiMd5).encrypt(Boolean.FALSE);
        }
        if (ImeiAndIdfaUtils.isOaid(this.oaid)) {
            String oaidMd5 = DigestUtils.md5Hex((String)this.oaid);
            this.deviceType(DeviceType.OAID).oaidMd5(oaidMd5).deviceUniqueId(oaidMd5).encrypt(Boolean.FALSE);
        }
    }

    private void setIfEncryptTrue() {
        if (ImeiAndIdfaUtils.isLowerCase32Md5(this.idfa)) {
            this.deviceType(DeviceType.IDFA).idfaMd5(this.idfa).deviceUniqueId(this.idfa).encrypt(Boolean.TRUE);
        } else if (ImeiAndIdfaUtils.isUpperCase32Md5(this.idfa)) {
            String lowerCaseIdfa = StringUtils.lowerCase((String)this.idfa);
            this.deviceType(DeviceType.IDFA).idfaMd5(lowerCaseIdfa).deviceUniqueId(lowerCaseIdfa).encrypt(Boolean.TRUE);
        }
        if (ImeiAndIdfaUtils.isLowerCase32Md5(this.imei)) {
            this.deviceType(DeviceType.IMEI).imeiMd5(this.imei).deviceUniqueId(this.imei).encrypt(Boolean.TRUE);
        } else if (ImeiAndIdfaUtils.isUpperCase32Md5(this.imei)) {
            String lowerCaseImei = StringUtils.lowerCase((String)this.imei);
            this.deviceType(DeviceType.IMEI).imeiMd5(lowerCaseImei).deviceUniqueId(lowerCaseImei).encrypt(Boolean.TRUE);
        }
        if (ImeiAndIdfaUtils.isLowerCase32Md5(this.oaid)) {
            this.deviceType(DeviceType.OAID).oaidMd5(this.oaid).deviceUniqueId(this.oaid).encrypt(Boolean.TRUE);
        } else if (ImeiAndIdfaUtils.isUpperCase32Md5(this.oaid)) {
            String lowerCaseOaid = StringUtils.lowerCase((String)this.oaid);
            this.deviceType(DeviceType.OAID).oaidMd5(lowerCaseOaid).deviceUniqueId(lowerCaseOaid).encrypt(Boolean.TRUE);
        }
    }

    private void setIfEncryptDefault() {
        if (ImeiAndIdfaUtils.isLowerCase32Md5(this.idfa)) {
            this.deviceType(DeviceType.IDFA).idfaMd5(this.idfa).deviceUniqueId(this.idfa).encrypt(Boolean.TRUE);
        } else if (ImeiAndIdfaUtils.isUpperCase32Md5(this.idfa)) {
            String lowerCaseIdfa = StringUtils.lowerCase((String)this.idfa);
            this.deviceType(DeviceType.IDFA).idfaMd5(lowerCaseIdfa).deviceUniqueId(lowerCaseIdfa).encrypt(Boolean.TRUE);
        }
        if (ImeiAndIdfaUtils.isIdfa(this.idfa)) {
            String idfaMd5 = DigestUtils.md5Hex((String)this.idfa);
            this.deviceType(DeviceType.IDFA).idfaMd5(idfaMd5).deviceUniqueId(idfaMd5).encrypt(Boolean.FALSE);
        }
        if (ImeiAndIdfaUtils.isLowerCase32Md5(this.imei)) {
            this.deviceType(DeviceType.IMEI).imeiMd5(this.imei).deviceUniqueId(this.imei).encrypt(Boolean.TRUE);
        } else if (ImeiAndIdfaUtils.isUpperCase32Md5(this.imei)) {
            String lowerCaseImei = StringUtils.lowerCase((String)this.imei);
            this.deviceType(DeviceType.IMEI).imeiMd5(lowerCaseImei).deviceUniqueId(lowerCaseImei).encrypt(Boolean.TRUE);
        }
        if (ImeiAndIdfaUtils.isImei(this.imei)) {
            String imeiMd5 = DigestUtils.md5Hex((String)this.imei);
            this.deviceType(DeviceType.IMEI).imeiMd5(imeiMd5).deviceUniqueId(imeiMd5).encrypt(Boolean.FALSE);
        }
        if (ImeiAndIdfaUtils.isOaid(this.oaid)) {
            String oaidMd5 = DigestUtils.md5Hex((String)this.oaid);
            this.deviceType(DeviceType.OAID).oaidMd5(oaidMd5).deviceUniqueId(oaidMd5).encrypt(Boolean.FALSE);
        }
        if (ImeiAndIdfaUtils.isLowerCase32Md5(this.oaid)) {
            this.deviceType(DeviceType.OAID).oaidMd5(this.oaid).deviceUniqueId(this.oaid).encrypt(Boolean.TRUE);
        } else if (ImeiAndIdfaUtils.isUpperCase32Md5(this.oaid)) {
            String lowerCaseOaid = StringUtils.lowerCase((String)this.oaid);
            this.deviceType(DeviceType.OAID).oaidMd5(lowerCaseOaid).deviceUniqueId(lowerCaseOaid).encrypt(Boolean.TRUE);
        }
    }

    private void resetInitValue() {
        if (ImeiAndIdfaUtils.isBlackDevice(this.imei)) {
            this.imei = null;
        }
        if (ImeiAndIdfaUtils.isBlackDevice(this.idfa)) {
            this.idfa = null;
        }
        if (ImeiAndIdfaUtils.isBlackDevice(this.oaid)) {
            this.oaid = null;
        }
    }

    private void resetInitValue(Map<String, String> extBlack) {
        if (MapUtils.isEmpty(extBlack)) {
            this.resetInitValue();
            return;
        }
        if (ImeiAndIdfaUtils.isBlackDevice(this.imei) || ImeiAndIdfaUtils.isBlackDeviceExt(this.imei, extBlack)) {
            this.imei = null;
        }
        if (ImeiAndIdfaUtils.isBlackDevice(this.idfa) || ImeiAndIdfaUtils.isBlackDeviceExt(this.idfa, extBlack)) {
            this.idfa = null;
        }
        if (ImeiAndIdfaUtils.isBlackDevice(this.oaid) || ImeiAndIdfaUtils.isBlackDeviceExt(this.oaid, extBlack)) {
            this.oaid = null;
        }
    }

    public String getOriginDeviceUniqueId() {
        if (StringUtils.isNotBlank((CharSequence)this.imei)) {
            return this.imei;
        }
        if (StringUtils.isNotBlank((CharSequence)this.idfa)) {
            return this.idfa;
        }
        if (StringUtils.isNotBlank((CharSequence)this.oaid)) {
            return this.oaid;
        }
        return "";
    }

    public String toString() {
        return "DeviceInfo(imei=" + this.getImei() + ", idfa=" + this.getIdfa() + ", oaid=" + this.getOaid() + ", isEncrypt=" + this.getIsEncrypt() + ", deviceType=" + (Object)((Object)this.getDeviceType()) + ", deviceUniqueId=" + this.getDeviceUniqueId() + ", imeiMd5=" + this.getImeiMd5() + ", idfaMd5=" + this.getIdfaMd5() + ", oaidMd5=" + this.getOaidMd5() + ")";
    }

    public Boolean getIsEncrypt() {
        return this.isEncrypt;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public void setIdfa(String idfa) {
        this.idfa = idfa;
    }

    public void setOaid(String oaid) {
        this.oaid = oaid;
    }

    public void setIsEncrypt(Boolean isEncrypt) {
        this.isEncrypt = isEncrypt;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public void setDeviceUniqueId(String deviceUniqueId) {
        this.deviceUniqueId = deviceUniqueId;
    }

    public void setImeiMd5(String imeiMd5) {
        this.imeiMd5 = imeiMd5;
    }

    public void setIdfaMd5(String idfaMd5) {
        this.idfaMd5 = idfaMd5;
    }

    public void setOaidMd5(String oaidMd5) {
        this.oaidMd5 = oaidMd5;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceInfo)) {
            return false;
        }
        DeviceInfo other = (DeviceInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$imei = this.getImei();
        String other$imei = other.getImei();
        if (this$imei == null ? other$imei != null : !this$imei.equals(other$imei)) {
            return false;
        }
        String this$idfa = this.getIdfa();
        String other$idfa = other.getIdfa();
        if (this$idfa == null ? other$idfa != null : !this$idfa.equals(other$idfa)) {
            return false;
        }
        String this$oaid = this.getOaid();
        String other$oaid = other.getOaid();
        if (this$oaid == null ? other$oaid != null : !this$oaid.equals(other$oaid)) {
            return false;
        }
        Boolean this$isEncrypt = this.getIsEncrypt();
        Boolean other$isEncrypt = other.getIsEncrypt();
        if (this$isEncrypt == null ? other$isEncrypt != null : !((Object)this$isEncrypt).equals(other$isEncrypt)) {
            return false;
        }
        DeviceType this$deviceType = this.getDeviceType();
        DeviceType other$deviceType = other.getDeviceType();
        if (this$deviceType == null ? other$deviceType != null : !((Object)((Object)this$deviceType)).equals((Object)other$deviceType)) {
            return false;
        }
        String this$deviceUniqueId = this.getDeviceUniqueId();
        String other$deviceUniqueId = other.getDeviceUniqueId();
        if (this$deviceUniqueId == null ? other$deviceUniqueId != null : !this$deviceUniqueId.equals(other$deviceUniqueId)) {
            return false;
        }
        String this$imeiMd5 = this.getImeiMd5();
        String other$imeiMd5 = other.getImeiMd5();
        if (this$imeiMd5 == null ? other$imeiMd5 != null : !this$imeiMd5.equals(other$imeiMd5)) {
            return false;
        }
        String this$idfaMd5 = this.getIdfaMd5();
        String other$idfaMd5 = other.getIdfaMd5();
        if (this$idfaMd5 == null ? other$idfaMd5 != null : !this$idfaMd5.equals(other$idfaMd5)) {
            return false;
        }
        String this$oaidMd5 = this.getOaidMd5();
        String other$oaidMd5 = other.getOaidMd5();
        return !(this$oaidMd5 == null ? other$oaidMd5 != null : !this$oaidMd5.equals(other$oaidMd5));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeviceInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $imei = this.getImei();
        result = result * 59 + ($imei == null ? 43 : $imei.hashCode());
        String $idfa = this.getIdfa();
        result = result * 59 + ($idfa == null ? 43 : $idfa.hashCode());
        String $oaid = this.getOaid();
        result = result * 59 + ($oaid == null ? 43 : $oaid.hashCode());
        Boolean $isEncrypt = this.getIsEncrypt();
        result = result * 59 + ($isEncrypt == null ? 43 : ((Object)$isEncrypt).hashCode());
        DeviceType $deviceType = this.getDeviceType();
        result = result * 59 + ($deviceType == null ? 43 : ((Object)((Object)$deviceType)).hashCode());
        String $deviceUniqueId = this.getDeviceUniqueId();
        result = result * 59 + ($deviceUniqueId == null ? 43 : $deviceUniqueId.hashCode());
        String $imeiMd5 = this.getImeiMd5();
        result = result * 59 + ($imeiMd5 == null ? 43 : $imeiMd5.hashCode());
        String $idfaMd5 = this.getIdfaMd5();
        result = result * 59 + ($idfaMd5 == null ? 43 : $idfaMd5.hashCode());
        String $oaidMd5 = this.getOaidMd5();
        result = result * 59 + ($oaidMd5 == null ? 43 : $oaidMd5.hashCode());
        return result;
    }
}

