/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.tools.deviceid.v2;

import cn.tuia.tools.deviceid.DeviceMd5BlackEnum;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class ImeiAndIdfaUtils {
    private static Pattern PATTERN_IMEI_ONE = Pattern.compile("\\d{15}$");
    private static Pattern PATTERN_IMEI_TWO = Pattern.compile("^(A|a)\\d{14}$");
    private static Pattern PATTERN_IDFA = Pattern.compile("^([0-9A-Z]{1,})(([/\\s-][0-9A-Z]{1,}){4})$");
    private static Pattern PATTERN_IDFA_LENGTH = Pattern.compile("^.{36}$");
    private static Pattern PATTERN_MD5_LOWER_CASE = Pattern.compile("^([0-9a-f]{32})$");
    private static Pattern PATTERN_MD5_UPPER_CASE = Pattern.compile("^([0-9A-F]{32})$");

    public static final boolean isImei(String imei) {
        if (StringUtils.isNotBlank((String)imei)) {
            return PATTERN_IMEI_ONE.matcher(imei.trim()).matches() || PATTERN_IMEI_TWO.matcher(imei.trim()).matches();
        }
        return false;
    }

    public static final boolean isIdfa(String idfa) {
        if (StringUtils.isNotBlank((String)idfa)) {
            return PATTERN_IDFA.matcher(idfa).matches() && PATTERN_IDFA_LENGTH.matcher(idfa).matches();
        }
        return false;
    }

    public static final boolean isOaid(String oaid) {
        if (StringUtils.isBlank((String)oaid)) {
            return false;
        }
        return !oaid.startsWith("__") && !oaid.endsWith("__");
    }

    public static final boolean isLowerCase32Md5(String str) {
        if (StringUtils.isNotBlank((String)str)) {
            return PATTERN_MD5_LOWER_CASE.matcher(str.trim()).matches();
        }
        return false;
    }

    public static final boolean isUpperCase32Md5(String str) {
        if (StringUtils.isNotBlank((String)str)) {
            return PATTERN_MD5_UPPER_CASE.matcher(str.trim()).matches();
        }
        return false;
    }

    public static final boolean isBlackDevice(String deviceId) {
        if (StringUtils.isBlank((String)deviceId)) {
            return true;
        }
        if (deviceId.startsWith("__") && deviceId.endsWith("__")) {
            return true;
        }
        if (!DeviceMd5BlackEnum.checkDeviceIdLegal(deviceId)) {
            return true;
        }
        return !DeviceMd5BlackEnum.checkDeviceIdBlack(deviceId);
    }

    public static final boolean isBlackDeviceExt(String deviceId, Map<String, String> extBlack) {
        if (extBlack.keySet().contains(deviceId)) {
            return true;
        }
        return extBlack.values().contains(deviceId);
    }
}

