/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.tools.log;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component
public class PublicConfigLog
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(PublicConfigLog.class);
    private static boolean can_log;

    public void run(ApplicationArguments var1) {
        can_log = !SpringEnvironmentUtils.isProdEnv() || ObjectUtils.notEqual((Object)System.getenv("deploy_type"), (Object)"normal");
    }

    private static boolean reasonable(String format) {
        return StringUtils.isNotBlank((String)format) && can_log;
    }

    public static void debug(String format, Object ... arguments) {
        if (PublicConfigLog.reasonable(format)) {
            log.debug(format, arguments);
        }
    }

    public static void info(String format, Object ... arguments) {
        if (PublicConfigLog.reasonable(format)) {
            log.info(format, arguments);
        }
    }

    public static void warn(String format, Object ... arguments) {
        if (PublicConfigLog.reasonable(format)) {
            log.warn(format, arguments);
        }
    }

    public static void error(String format, Object ... arguments) {
        if (PublicConfigLog.reasonable(format)) {
            log.error(format, arguments);
        }
    }
}

