/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.tools.shunt;

import org.apache.commons.lang.StringUtils;

public class StyleTypeUtil {
    private static final Long BASICS = 2520L;
    private static final Long HALF_FACTOR = 1260L;
    private static final Long ONE_THIRD_FACTOR = 840L;
    private static final Long QUARTER_FACTOR = 630L;
    private static final Long ONE_FIFTH_FACTOR = 504L;
    private static final Long ONE_TENTH_FACTOR = 252L;
    private static final Long ONE_TWENTIETH_FACTOR = 126L;

    private StyleTypeUtil() {
    }

    public static Long half(Long styleType) {
        if (styleType == null) {
            return 1L;
        }
        return (styleType - 1L) / HALF_FACTOR + 1L;
    }

    public static Long oneThird(Long styleType) {
        if (styleType == null) {
            return 1L;
        }
        return (styleType - 1L) / ONE_THIRD_FACTOR + 1L;
    }

    public static Long quarter(Long styleType) {
        if (styleType == null) {
            return 1L;
        }
        return (styleType - 1L) / QUARTER_FACTOR + 1L;
    }

    public static Long oneFifth(Long styleType) {
        if (styleType == null) {
            return 1L;
        }
        return (styleType - 1L) / ONE_FIFTH_FACTOR + 1L;
    }

    public static Long oneTenth(Long styleType) {
        if (styleType == null) {
            return 1L;
        }
        return (styleType - 1L) / ONE_TENTH_FACTOR + 1L;
    }

    public static Long oneTwentieth(Long styleType) {
        if (styleType == null) {
            return 1L;
        }
        return (styleType - 1L) / ONE_TWENTIETH_FACTOR + 1L;
    }

    public static Long customRatio(Integer ratio) {
        if (ratio == null) {
            return 1L;
        }
        return BASICS * (long)ratio.intValue() / 100L;
    }

    public static Long userIdToStyleType(String userId) {
        if (StringUtils.isBlank((String)userId)) {
            return 1L;
        }
        return (long)Math.abs(userId.hashCode()) % BASICS + 1L;
    }

    public static boolean getFlowScale(Long styleType, Long flowScale) {
        Long splitFlow = 126L * (20L - flowScale);
        return styleType > splitFlow;
    }

    public static boolean encShuntByConsumerId(Long consumerId) {
        return Boolean.TRUE;
    }

    public static boolean hitFlowByTwoRange(long styleType, long startNumOne, long endNumOne, long startNumTwo, long endNumTwo) {
        return styleType >= startNumOne && styleType <= endNumOne || styleType >= startNumTwo && styleType <= endNumTwo;
    }
}

