/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.tools.ua;

import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UACleanUtils {
    private static final Logger log = LoggerFactory.getLogger(UACleanUtils.class);

    public static String clean(String userAgent) {
        if (StringUtils.isBlank((String)userAgent)) {
            return "";
        }
        if (!(userAgent = UACleanUtils.handleUserAgent(userAgent)).contains("Android")) {
            return UACleanUtils.handleUserAgentDefault(userAgent);
        }
        String result = UACleanUtils.handleUserAgentAndroid(userAgent);
        if (StringUtils.isBlank((String)result)) {
            return UACleanUtils.handleUserAgentDefault(userAgent);
        }
        return result;
    }

    private static String handleUserAgent(String userAgent) {
        try {
            userAgent = URLDecoder.decode(userAgent.trim(), "utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return userAgent;
    }

    private static String handleUserAgentDefault(String ua) {
        Pattern pattern = Pattern.compile("\\(.*?\\)");
        Matcher matcher = pattern.matcher(ua);
        if (matcher.find()) {
            ua = StringUtils.defaultString((String)matcher.group());
        }
        ua = ua.replaceAll(" U;", "");
        ua = ua.replaceAll("; wv", "");
        ua = ua.replaceAll("\\s\\w\\w-\\w\\w;", "");
        ua = ua.replaceAll("0.0;", "0;");
        ua = ua.replaceAll("1.0;", "1;");
        ua = ua.replaceAll("zh-cn;", "");
        ua = ua.replaceAll("zh-CN;", "");
        ua = ua.replaceAll(" ", "");
        ua = ua.replaceAll("%20", "");
        return ua;
    }

    private static String handleUserAgentAndroid(String ua) {
        ua = ua.replaceAll(" U;", "");
        ua = ua.replaceAll("; wv", "");
        ua = ua.replaceAll("\\s\\w\\w-\\w\\w;", "");
        Matcher matcher = Pattern.compile("Android\\s\\d.*?/").matcher(ua);
        if (!matcher.find()) {
            return "";
        }
        ua = matcher.group();
        String[] uas = ua.split(";");
        if (uas.length < 1) {
            return "";
        }
        String system = "";
        String model = "";
        for (String uaStr : uas) {
            if (uaStr.contains("Android")) {
                Matcher systemMatcher = Pattern.compile("Android\\s\\d+").matcher(uaStr);
                if (!systemMatcher.find()) continue;
                system = systemMatcher.group();
                continue;
            }
            if (!uaStr.contains("/")) continue;
            model = uaStr.trim().split(" ")[0];
        }
        return StringUtils.isNotBlank((String)system) && StringUtils.isNotBlank((String)model) ? (system + model).replaceAll(" ", "") : "";
    }
}

