/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.tools.util;

import cn.tuia.tools.deviceid.v2.ImeiAndIdfaUtils;
import org.apache.commons.lang.StringUtils;

public class DeviceIdTypeUtils {
    public static String checkDeviceIdType(String deviceId) {
        if (StringUtils.isBlank((String)deviceId)) {
            return DeviceIdTypeEnum.VIRTUAL.code;
        }
        if (deviceId.startsWith("__") || deviceId.endsWith("__")) {
            return DeviceIdTypeEnum.VIRTUAL.code;
        }
        if (deviceId.length() == 16 || DeviceIdTypeUtils.checkUuid(deviceId)) {
            return DeviceIdTypeEnum.VIRTUAL.code;
        }
        if (ImeiAndIdfaUtils.isLowerCase32Md5(deviceId) || ImeiAndIdfaUtils.isUpperCase32Md5(deviceId)) {
            return DeviceIdTypeEnum.REAL.code;
        }
        return DeviceIdTypeEnum.VIRTUAL.code;
    }

    private static boolean checkUuid(String uuid) {
        boolean isUuid = false;
        if (uuid.matches("([0-9a-fA-F]{8}(-[0-9a-fA-F]{4}){3}-[0-9a-fA-F]{12}?)")) {
            return true;
        }
        return isUuid;
    }

    public static enum DeviceIdTypeEnum {
        REAL("1", "\u771f\u5b9e"),
        VIRTUAL("2", "\u865a\u62df");

        private String code;
        private String desc;

        private DeviceIdTypeEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

