package cn.yoofans.knowledge.center.api.enums;

/**
 * 分销绑定状态枚举类
 */
public enum DistributionBindStatusEnum {

    UNTIE(0, "已解绑"),

    BINDING(1, "绑定中");


    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    DistributionBindStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 依据code获取对应的课程类型
     *
     * @param code
     * @return
     */
    public static DistributionBindStatusEnum getByCode(Integer code) {
        for (DistributionBindStatusEnum status : DistributionBindStatusEnum.values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
