package cn.yoofans.knowledge.center.api.enums;

/**
 * 商品组分销标志枚举类
 */
public enum GoodsGroupDistributeMarkEnum {

    NON_DISTRIBUTION(0, "非分销商品组"),

    DISTRIBUTION(1, "分销商品组");


    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    GoodsGroupDistributeMarkEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 依据code获取对应的课程类型
     *
     * @param code
     * @return
     */
    public static GoodsGroupDistributeMarkEnum getByCode(Integer code) {
        for (GoodsGroupDistributeMarkEnum status : GoodsGroupDistributeMarkEnum.values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
