package cn.yoofans.knowledge.center.api.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by sunyan on 2018/4/10.
 */
public enum PayTypeEnum {
	/** 微信小程序支付 */
    WECHATWXAPAY("WECHATWXAPAY","微信小程序支付");
    
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private static Map<String,PayTypeEnum> enumMap = Maps.newHashMap();
    static {
        for(PayTypeEnum it:PayTypeEnum.values()){
            enumMap.put(it.code,it);
        }
    }

    public static PayTypeEnum getEnumByCode(String code){
        return enumMap.get(code);
    }


    private PayTypeEnum(String code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

}
