package cn.yoofans.knowledge.center.api.param;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;

/**
 * 基本分页请求参数
 *
 * @author qiuyp
 */
public class BasePageReqParam implements Serializable {


    private static final long serialVersionUID = 2922776169345436048L;
    /**
     * 页码，默认页码为1
     */
    private Integer pageNum = 1;

    /**
     * 分页大小，默认分页大小为20
     */
    private Integer pageSize = 20;

    /**
     * 开始行
     */
    private Integer startIndex;

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getStartIndex() {
        return startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public BasePageReqParam() {
        super();
    }

    public BasePageReqParam(Integer pageNum, Integer pageSize) {
        super();
        this.pageNum = null == pageNum ? 1 : pageNum;
        this.pageSize = null == pageSize ? 20 : pageSize;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
