package cn.yoofans.knowledge.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.ColumnDTO;
import cn.yoofans.knowledge.center.api.param.RemoteColumnPageReqParam;
import org.springframework.data.domain.PageImpl;

import java.util.List;

/**
 * Created by qiuyp on 2018/4/9.
 */
@AdvancedFeignClient
public interface RemoteColumnService {

    /**
     * 新增专栏
     *
     * @param dto
     * @return
     */
    public ColumnDTO add(ColumnDTO dto) throws BizException;

    /**
     * 删除专栏
     *
     * @param id
     * @return
     */
    public Boolean deleteById(Long id) throws BizException;

    /**
     * 修改专栏基本信息
     *
     * @param dto
     * @return
     */
    public Boolean update(ColumnDTO dto) throws BizException;

    /**
     * 依据Id查询专栏信息
     *
     * @param id
     * @return
     */
    public ColumnDTO findById(Long id) throws BizException;

    /**
     * 按照专栏Id，专栏状态获得专栏集合
     *
     * @param ids
     * @param columnStatus 为null时查询所有状态
     * @return
     */
    List<ColumnDTO> findByIds(List<Long> ids,Short columnStatus);

    /**
     * 获取按照商品组ID过滤专栏的分页
     *
     * @param goodsGroupId
     * @param title
     * @param pageNum
     * @param pageSize
     * @return
     */

    List<ColumnDTO> getListFilterByGroupId(Long goodsGroupId, String title, Integer pageNum, Integer pageSize);

    /**
     * 总数
     *
     * @param goodsGroupId
     * @param title
     * @return
     */
    Long getListFilterByGroupIdCount(Long goodsGroupId, String title);


    /**
     * 分页查询专栏列表
     *
     * @param requestParam
     * @return
     */
    public PageImpl<ColumnDTO> getPageList(RemoteColumnPageReqParam requestParam);

    /**
     * 更新专栏状态
     *
     * @param id
     * @param status
     * @return
     */
    public Boolean updateStatus(Long id, Integer status) throws BizException;

    /**
     * 获取专栏详情
     *
     * @param id
     * @return
     */
    public String getDetailById(Long id);

    /**
     * 购买次数+1
     *
     * @param id
     * @return
     */
    public boolean buyTimesIncrement(Long id);
}
