package cn.yoofans.knowledge.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.distribution.DistributorDTO;
import org.springframework.data.domain.PageImpl;

import java.util.Date;

/**
 * 分销员远程调用Service
 *
 * @author qiuyp
 */
@AdvancedFeignClient
public interface RemoteDistributorService {

    /**
     * 新增分销员
     *
     * @param dto
     * @return
     */
    public DistributorDTO add(DistributorDTO dto);

    /**
     * 删除分销员
     *
     * @param id
     * @return
     */
    public Boolean deleteById(Long id);

    /**
     * 修改分销员
     *
     * @param dto
     * @return
     */
    public Boolean update(DistributorDTO dto) throws BizException;

    /**
     * 依据Id查询
     *
     * @param id
     * @return
     */
    public DistributorDTO findById(Long id);

    /**
     * 分页查询
     *
     * @param nickName
     * @param createTimeStart
     * @param createTimeEnd
     * @param orderBy
     * @param sorted
     * @param pageNum
     * @param pageSize
     * @return
     */
    public PageImpl<DistributorDTO> getPageList(String nickName, Date createTimeStart, Date createTimeEnd, String orderBy, String sorted, Integer pageNum, Integer pageSize);


}
