package cn.yoofans.knowledge.center.api.remoteservice;

import java.util.List;

import org.springframework.data.domain.PageImpl;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.order.OrderDetailDto;
import cn.yoofans.knowledge.center.api.dto.order.OrderDto;
import cn.yoofans.knowledge.center.api.param.CreateOrderParams;
import cn.yoofans.knowledge.center.api.param.OrderPageParam;

/**
 * Created by sunyan on 2018/4/11.
 */
@AdvancedFeignClient
public interface RemoteOrderService {

    /**
     * 创建订单
     *
     * @param createOrderParams
     * @return
     */
    OrderDto createOrder(CreateOrderParams createOrderParams);

    /**
     * 订单查询
     *
     * @param orderId
     * @return
     */
    OrderDto getByOrderId(String orderId);

    /**
     * 分页查询
     *
     * @param orderPageParam
     * @return
     */
    PageImpl<OrderDto> findByPage(OrderPageParam orderPageParam);

    /**
     * 订单详情
     *
     * @param orderId
     * @return
     */
    OrderDetailDto findDetail(String orderId);

    /**
     * 导出数据
     *
     * @param orderPageParam
     * @return
     */
    List<OrderDto> export(OrderPageParam orderPageParam);
}
