/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: RemotePageService
 * Author:   amu
 * Date:     2018/4/11 下午9:46
 * Description:
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.yoofans.knowledge.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.PageDTO;

import java.util.List;

/**
 * 〈一句话功能简述〉<br> 
 * 〈〉
 *
 * @author amu
 * @create 2018/4/11
 * @since 1.0.0
 */
@AdvancedFeignClient
public interface RemotePageService {
    /**
     * 获取分页
     * @param pageTitle
     * @param authorizerId
     * @param pageNum
     * @param pageSize
     * @return
     */
    List<PageDTO> findByPage(String pageTitle,Long  authorizerId,Integer pageNum, Integer pageSize);

    /**
     * 分页查询的总数
     * @param pageTitle
     * @return
     */
    Long findByPageCount(String pageTitle,Long  authorizerId);


    /**
     * 新增
     * @param pageDTO
     * @return
     */
    PageDTO insert(PageDTO pageDTO);

    /**
     * 修改
     * @param pageDTO
     * @return
     */
    Boolean update(PageDTO pageDTO);

    /**
     * 删除
     * @param id
     * @return
     */
    Boolean delete(Long id);

    /**
     * 按照ID查找
     * @param id
     * @return
     */
    PageDTO findById(Long id);

    /**
     * 设为主页
     * @param id
     * @return
     */
    Boolean updateHomePage(Long id);

    /**
     * 添加页面组件
     * @param pageDTO
     * @param components
     * @return
     */
    Boolean insertComponents(PageDTO pageDTO ,String components);

    /**
     * 复制页面组件
     * @param id
     * @param components
     * @return
     */
    Boolean copyComponents(Long id,String components);

    /**
     * 根据应用获取首页信息
     * @param appId
     * @return
     */
    PageDTO findHomeByAuthorizerId(String appId);


}
