package cn.yoofans.knowledge.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.UserItemDTO;
import cn.yoofans.knowledge.center.api.param.UserPlayProgressParams;

import java.util.List;

/**
 * Created by sunyan on 2018/4/13.
 */
@AdvancedFeignClient
public interface RemoteUserItemService {
    /**
     * 是否有权限
     * @param consumerId
     * @param itemId
     * @param itemType
     * @return
     */
    boolean checkPower(Long consumerId, Long itemId,Integer itemType);

    /**
     * 用户已购分页查询
     * @param consumerId
     * @param pageNum
     * @param pageSize
     * @return
     */
    List<UserItemDTO> findByPage(Long consumerId,Integer pageNum,Integer pageSize);

    /**
     * 统计
     * @param consumerId
     * @return
     */
    Long findByPageCount(Long consumerId);

    /**
     * 更新用户已购播放进度
     * @param userPlayProgressParams
     * @return
     */

    public Boolean updatePlayBackProgress(UserPlayProgressParams userPlayProgressParams);

    /**
     * 通过cid,itemId,itemtype查询数据
     *
     * @param cid
     * @param itemId
     * @param itemType
     * @return
     */
    public UserItemDTO findByCidAndItemIdAndItemType(Long cid, Long itemId, Byte itemType);
}
