package cn.yoofans.knowledge.center.api.dto.order;

import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang3.builder.ToStringBuilder;

public class OrderDto implements Serializable {

    private static final long serialVersionUID = 4327709390108505192L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 小程序ID
     */
    private Long authorizerId;

    /**
     * 推广位ID
     */
    private Long adzoneId;

    /**
     * 推广位ID
     */
    private String adzoneName;

    /**
     * 订单ID
     */
    private String orderId;

    /**
     * 订单类型
     */
    private String orderType;

    /**
     * 订单金额（单位：分）
     */
    private Integer amount;

    /**
     * 付款方式
     */
    private String payType;

    /**
     * 外部流水号
     */
    private String outSeqNo;

    /**
     * 商品ID
     */
    private Long itemId;

    /**
     * 商品名称
     */
    private String itemName;

    /**
     * 商品图片
     */
    private String itemImage;

    /**
     * 商品价格（单位：分）
     */
    private Integer itemPrice;

    /**
     * 商品类型（单节，专栏）
     */
    private Integer itemType;

    /**
     * 商品种类（音频，视频）
     */
    private Integer itemCategory;

    /**
     * 商品数量
     */
    private Integer itemNum;

    /**
     * 分销比例
     */
    private Integer distributeRate;

    /**
     * 买家ID
     */
    private Long consumerId;

    /**
     * 买家昵称
     */
    private String consumerName;

    /**
     * 渠道ID
     */
    private Long channelId;

    /**
     * 渠道名称
     */
    private String channelName;

    /**
     * 渠道分成比例（100=%1）
     */
    private Integer channelRate;

    /**
     * 讲师ID
     */
    private Long lecturerId;

    /**
     * 讲师名称
     */
    private String lecturerName;

    /**
     * 讲师分成比例（100=%1）
     */
    private Integer lecturerRate;

    /**
     * 订单状态（待付款、付款成功、付款失败、退款中、退款成功、退款失败）
     */
    private String orderStatus;

    /**
     * 备注
     */
    private String remark;

    /**
     * 交易完成时间
     */
    private Date finishTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 分销员Id
     */
    private Long distributorId;

    /**
     * 分销员名称
     */
    private String distributorName;

/**
     * 优惠券ID
     */
    private String couponId;

    /**
     * 优惠券母版表主键ID
     */
    private String couponTemplateId;

    /**
     * 母版标题
     */
    private String couponTemplateTitle;

    /**
     * 使用条件类型，1:满减;2:直减
     */
    private String couponCondition;

    /**
     * 使用条件类型，1:满减;2:直减
     */
    private Integer couponConditionType;

    /**
     * 使用条件金额(分)
     */
    private Integer couponConditionValue;

    /**
     * 券面额(分)
     */
    private Integer couponPrice;

    /**
     * 使用范围类型，1:定向；2:通用
     */
    private Short couponUseScopeType;

    /**
     * 优惠券落地使用页面类型 1内容详情页 2:指定页面
     */
    private Integer couponPageType;

    /**
     * 优惠券落地页ID,课程或专栏表ID或内容详情页ID
     */
    private Integer couponPageId;
	
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId == null ? null : orderId.trim();
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus == null ? null : orderStatus.trim();
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType == null ? null : orderType.trim();
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Long getAuthorizerId() {
        return authorizerId;
    }

    public void setAuthorizerId(Long authorizerId) {
        this.authorizerId = authorizerId;
    }

    public Long getAdzoneId() {
        return adzoneId;
    }

    public void setAdzoneId(Long adzoneId) {
        this.adzoneId = adzoneId;
    }

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getPayType() {
        return payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public String getOutSeqNo() {
        return outSeqNo;
    }

    public void setOutSeqNo(String outSeqNo) {
        this.outSeqNo = outSeqNo;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemImage() {
        return itemImage;
    }

    public void setItemImage(String itemImage) {
        this.itemImage = itemImage;
    }

    public Integer getItemPrice() {
        return itemPrice;
    }

    public void setItemPrice(Integer itemPrice) {
        this.itemPrice = itemPrice;
    }

    public Integer getItemType() {
        return itemType;
    }

    public void setItemType(Integer itemType) {
        this.itemType = itemType;
    }

    public Integer getItemCategory() {
        return itemCategory;
    }

    public void setItemCategory(Integer itemCategory) {
        this.itemCategory = itemCategory;
    }

    public Integer getItemNum() {
        return itemNum;
    }

    public void setItemNum(Integer itemNum) {
        this.itemNum = itemNum;
    }

    public String getConsumerName() {
        return consumerName;
    }

    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Integer getChannelRate() {
        return channelRate;
    }

    public void setChannelRate(Integer channelRate) {
        this.channelRate = channelRate;
    }

    public Long getLecturerId() {
        return lecturerId;
    }

    public void setLecturerId(Long lecturerId) {
        this.lecturerId = lecturerId;
    }

    public String getLecturerName() {
        return lecturerName;
    }

    public void setLecturerName(String lecturerName) {
        this.lecturerName = lecturerName;
    }

    public Integer getLecturerRate() {
        return lecturerRate;
    }

    public void setLecturerRate(Integer lecturerRate) {
        this.lecturerRate = lecturerRate;
    }

    public String getCouponId() {
        return couponId;
    }

    public void setCouponId(String couponId) {
        this.couponId = couponId;
    }

    public String getCouponTemplateId() {
        return couponTemplateId;
    }

    public void setCouponTemplateId(String couponTemplateId) {
        this.couponTemplateId = couponTemplateId;
    }

    public String getCouponTemplateTitle() {
        return couponTemplateTitle;
    }

    public void setCouponTemplateTitle(String couponTemplateTitle) {
        this.couponTemplateTitle = couponTemplateTitle;
    }

    public Integer getCouponConditionValue() {
        return couponConditionValue;
    }

    public void setCouponConditionValue(Integer couponConditionValue) {
        this.couponConditionValue = couponConditionValue;
    }

    public Integer getCouponConditionType() {
        return couponConditionType;
    }

    public void setCouponConditionType(Integer couponConditionType) {
        this.couponConditionType = couponConditionType;
    }

    public String getCouponCondition() {
        return couponCondition;
    }

    public void setCouponCondition(String couponCondition) {
        this.couponCondition = couponCondition;
    }

    public Integer getCouponPrice() {
        return couponPrice;
    }

    public void setCouponPrice(Integer couponPrice) {
        this.couponPrice = couponPrice;
    }

    public Short getCouponUseScopeType() {
        return couponUseScopeType;
    }

    public void setCouponUseScopeType(Short couponUseScopeType) {
        this.couponUseScopeType = couponUseScopeType;
    }

    public Integer getCouponPageType() {
        return couponPageType;
    }

    public void setCouponPageType(Integer couponPageType) {
        this.couponPageType = couponPageType;
    }

    public Integer getCouponPageId() {
        return couponPageId;
    }

    public void setCouponPageId(Integer couponPageId) {
        this.couponPageId = couponPageId;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    public String getAdzoneName() {
        return adzoneName;
    }

    public void setAdzoneName(String adzoneName) {
        this.adzoneName = adzoneName;
    }

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public Integer getDistributeRate() {
        return distributeRate;
    }

    public void setDistributeRate(Integer distributeRate) {
        this.distributeRate = distributeRate;
    }

    public Long getDistributorId() {
        return distributorId;
    }

    public void setDistributorId(Long distributorId) {
        this.distributorId = distributorId;
    }

    public String getDistributorName() {
        return distributorName;
    }

    public void setDistributorName(String distributorName) {
        this.distributorName = distributorName;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}