package cn.yoofans.knowledge.center.api.enums.coupon;

/**
 * 优惠券商品类型枚举
 * Created by qiuyp
 */
public enum CouponItemTypeEnum {
    COURSE(1, "单课"),

    COLUMN(2, "专栏"),

    READ(3, "阅读");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    CouponItemTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 依据code获取对应的商品类型
     *
     * @param code
     * @return
     */
    public static CouponItemTypeEnum getByCode(Integer code) {
        for (CouponItemTypeEnum status : CouponItemTypeEnum.values()) {
            if (status.code.equals(code)) {
                return status;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

}
