package cn.yoofans.knowledge.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.coupon.CouponInfoDto;
import cn.yoofans.knowledge.center.api.dto.coupon.CouponInfoPageDto;
import cn.yoofans.knowledge.center.api.param.coupon.CouponInfoExportQryParams;
import cn.yoofans.knowledge.center.api.param.coupon.CouponInfoPageQryParams;
import org.springframework.data.domain.PageImpl;

import java.util.List;

/**
 * 优惠券信息接口
 *
 * @author zhanghuifeng
 * @date 2018/4/23下午3:01
 */
@AdvancedFeignClient
public interface RemoteCouponInfoService {

    /**
     * 根据ID查询
     *
     * @param id ID
     * @return
     */
    CouponInfoDto getById(Long id);

    /**
     * 根据优惠券ID查询
     *
     * @param couponId 优惠券ID
     * @return
     */
    CouponInfoDto getByCouponId(String couponId);

    /**
     * 分页查询优惠券信息
     *
     * @param qryParams 查询条件
     * @return 分页数据
     */
    PageImpl<CouponInfoPageDto> findPage(CouponInfoPageQryParams qryParams);

    /**
     * @param params 查询参数
     * @return 集合
     */
    List<CouponInfoPageDto> findListForExport(CouponInfoExportQryParams params);

    /**
     * 更新过期的优惠券信息
     *
     * @return
     */
    Integer updateExpireCouponStatus();

    /**
     * 依据用户Id和优惠券状态查询数据
     *
     * @param cid
     * @param couponStatus
     * @return
     */
    List<CouponInfoDto> findCouponsByCidAndStatus(Long cid, Integer couponStatus);

    /**
     * 依据sourceType和sourceId查询优惠券数量
     *
     * @param sourceType
     * @param sourceId
     * @return
     */
    Long findCountBySourceTypesAndSourceId(Integer sourceType, Long sourceId);
}
