package cn.yoofans.knowledge.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.UserDistributionDto;
import cn.yoofans.knowledge.center.api.param.UserDistributionPageReqParams;
import org.springframework.data.domain.PageImpl;

import java.util.List;

/**
 * Created by sunyan on 2018/4/13.
 */
@AdvancedFeignClient
public interface RemoteUserDistributionService {
    /**
     * 绑定分销关系
     * @param consumerId
     * @param distributionCode
     * @return
     */
    Boolean binding(Long consumerId,String distributionCode);

    UserDistributionDto selectByCid(Long id);

    /**
     * 分页查询数据
     *
     * @param requestParam
     * @return
     */
    PageImpl<UserDistributionDto> getPageList(UserDistributionPageReqParams requestParam);

    /**
     * 获取状态为绑定中的已过期的数据的id集合
     *
     * @return
     */
    List<Long> findoverdueTimeList();

    /**
     * 批量修改绑定状态
     *
     * @param ids
     * @param bindStatus
     * @return
     */
    Boolean updateBindStatusByIds(List<Long> ids, Integer bindStatus);
}
