package cn.yoofans.knowledge.center.api.enums.coupon;

/**
 * 优惠券落地使用页面类型，1 单课 2 专栏 3一修读书报名页枚举
 *
 * @author qiuyp
 */
public enum CouponPageItemTypeEnum {
    COURSE(1, "单课"),
    COLUMN(2, "专栏"),
    READ(3, "一修读书");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    CouponPageItemTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CouponPageItemTypeEnum getByCode(Integer code) {
        for (CouponPageItemTypeEnum enumVal : CouponPageItemTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }
}
