/*
 * Decompiled with CFR 0.152.
 */
package cn.yoofans.knowledge.center.api.param.flow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class FlowPageImpl<T>
implements Page<T>,
Serializable {
    private static final long serialVersionUID = 867755909294344406L;
    private final List<T> content = new ArrayList<T>();
    private final Pageable pageable;
    private final long total;
    private final long last;

    public FlowPageImpl(List<T> content, Pageable pageable, long total, long last) {
        if (null == content) {
            throw new IllegalArgumentException("Content must not be null!");
        }
        this.content.addAll(content);
        this.pageable = pageable;
        this.total = total;
        this.last = last;
    }

    public FlowPageImpl(List<T> content) {
        this(content, null, null == content ? 0L : (long)content.size(), 0L);
    }

    public int getNumber() {
        return this.pageable == null ? 0 : this.pageable.getPageNumber();
    }

    public int getSize() {
        return this.pageable == null ? 0 : this.pageable.getPageSize();
    }

    public int getTotalPages() {
        return this.getSize() == 0 ? 0 : (int)Math.ceil((double)this.total / (double)this.getSize());
    }

    public int getNumberOfElements() {
        return this.content.size();
    }

    public long getTotalElements() {
        return this.total;
    }

    public boolean hasPreviousPage() {
        return this.getNumber() > 0;
    }

    public boolean isFirstPage() {
        return !this.hasPreviousPage();
    }

    public boolean hasNextPage() {
        return (long)((this.getNumber() + 1) * this.getSize()) < this.total;
    }

    public boolean isLastPage() {
        return !this.hasNextPage();
    }

    public Iterator<T> iterator() {
        return this.content.iterator();
    }

    public List<T> getContent() {
        return Collections.unmodifiableList(this.content);
    }

    public boolean hasContent() {
        return !this.content.isEmpty();
    }

    public Sort getSort() {
        return this.pageable == null ? null : this.pageable.getSort();
    }

    public Pageable getPageable() {
        return this.pageable;
    }

    public long getTotal() {
        return this.total;
    }

    public long getLast() {
        return this.last;
    }

    public String toString() {
        String contentType = "UNKNOWN";
        if (this.content.size() > 0) {
            contentType = this.content.get(0).getClass().getName();
        }
        return String.format("Page %s of %d last %s containing %s instances", this.getNumber(), this.getTotalPages(), this.last, contentType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowPageImpl flowPage = (FlowPageImpl)o;
        return this.total == flowPage.total && this.last == flowPage.last && Objects.equals(this.content, flowPage.content) && Objects.equals(this.pageable, flowPage.pageable);
    }

    public int hashCode() {
        return Objects.hash(this.content, this.pageable, this.total, this.last);
    }
}

