package cn.yoofans.knowledge.center.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;

/**
 * 专栏实体类
 *
 * @author qiuyp
 */
public class ColumnDTO extends BaseDTO implements Serializable {

    /**
     * 待上线
     */
    public static final Short TO_BE_ONLINE=new Short("0");
    /**
     * 已上线
     */
    public static final Short ALREADY_ONLINE=new Short("1");
    /**
     * 已下线
     */
    public static final Short ALREADY_OFFLINE=new Short("2");

    private static final long serialVersionUID = 7122670871621035301L;

    /**
     * 专栏标题
     */
    private String title;

    /**
     * 副标题
     */
    private String subTitle;

    /**
     * 专栏封面横向图
     */
    private String lateralCover;

    /**
     * 专栏封面竖向图
     */
    private String verticalCover;

    /**
     * 专栏详情
     */
    private String detail;

    /**
     * 专栏价格
     */
    private Long price;

    /**
     * 专栏状态 0:待上线 1：已上线 2：已下线
     */
    private Short status;

    /**
     * 抽成比例
     */
    private Integer rate;

    /**
     * 讲师id
     */
    private Long lecturerId;

    /**
     * 课程期数
     */
    private Integer courseNum;

    /**
     * 购买次数
     */
    private Long buyTimes;

    /**
     * 关联课程数
     */
    private Integer courseRelated = 0;

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLateralCover() {
        return lateralCover;
    }

    public void setLateralCover(String lateralCover) {
        this.lateralCover = lateralCover;
    }

    public String getVerticalCover() {
        return verticalCover;
    }

    public void setVerticalCover(String verticalCover) {
        this.verticalCover = verticalCover;
    }

    public String getDetail() {
        return detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public Long getPrice() {
        return price;
    }

    public void setPrice(Long price) {
        this.price = price;
    }

    public Short getStatus() {
        return status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    public Long getLecturerId() {
        return lecturerId;
    }

    public void setLecturerId(Long lecturerId) {
        this.lecturerId = lecturerId;
    }

    public Long getBuyTimes() {
        return buyTimes;
    }

    public void setBuyTimes(Long buyTimes) {
        this.buyTimes = buyTimes;
    }

    public Integer getRate() {
        return rate;
    }

    public void setRate(Integer rate) {
        this.rate = rate;
    }

    public String getSubTitle() {
        return subTitle;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public Integer getCourseNum() {
        return courseNum;
    }

    public void setCourseNum(Integer courseNum) {
        this.courseNum = courseNum;
    }

    public Integer getCourseRelated() {
        return courseRelated;
    }

    public void setCourseRelated(Integer courseRelated) {
        this.courseRelated = courseRelated;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
