package cn.yoofans.knowledge.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.LecturerDTO;
import cn.yoofans.knowledge.center.api.param.RemoteLecturerPageReqParam;
import org.springframework.data.domain.PageImpl;

import java.util.List;

/**
 * 讲师远程调用Service
 *
 * @author qiuyp
 */
@AdvancedFeignClient
public interface RemoteLecturerService {

    /**
     * 新增讲师
     *
     * @param dto
     * @return
     */
    public LecturerDTO add(LecturerDTO dto) throws BizException;

    /**
     * 删除讲师
     *
     * @param id
     * @return
     */
    public Boolean deleteById(Long id) throws BizException;

    /**
     * 修改讲师基本信息
     *
     * @param dto
     * @return
     */
    public Boolean update(LecturerDTO dto) throws BizException;

    /**
     * 依据Id查询讲师
     *
     * @param id
     * @return
     */
    public LecturerDTO findById(Long id) throws BizException;


    /**
     * 分页查询讲师列表
     *
     * @param requestParam
     * @return
     */
    public PageImpl<LecturerDTO> getPageList(RemoteLecturerPageReqParam requestParam);

    /**
     * 查询讲师列表
     *
     * @param id
     * @param nickName
     * @return
     */
    public List<LecturerDTO> getList(Long id, String nickName);


}
