package cn.yoofans.knowledge.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.CourseDTO;
import cn.yoofans.knowledge.center.api.dto.CourseSketchDTO;
import cn.yoofans.knowledge.center.api.dto.CourseSimpleInfoDto;
import cn.yoofans.knowledge.center.api.param.ColumnAndCourseQryParams;
import cn.yoofans.knowledge.center.api.param.RemoteCoursePageReqParam;
import cn.yoofans.knowledge.center.api.param.RemoteCourseWithColumnIdPageReqParam;

import org.springframework.data.domain.PageImpl;

import java.util.List;

/**
 * Created by qiuyp on 2018/4/9.
 */
@AdvancedFeignClient
public interface RemoteCourseService {

    /**
     * 新增课程
     *
     * @param dto
     * @return
     */
    public CourseDTO add(CourseDTO dto) throws BizException;

    /**
     * 删除课程
     *
     * @param id
     * @return
     */
    public Boolean deleteById(Long id) throws BizException;

    /**
     * 修改课程基本信息
     *
     * @param dto
     * @return
     */
    public Boolean update(CourseDTO dto) throws BizException;

    /**
     * 依据Id查询课程信息
     *
     * @param id
     * @return
     */
    public CourseDTO findById(Long id) throws BizException;

    /**
     * 按照课程Id，课程状态获得课程集合
     *
     * @param ids
     * @param courseStatus 为null时查询所有状态
     * @return
     */
    List<CourseDTO> findByIds(List<Long> ids, Short courseStatus);

    /**
     * 获取按照商品组ID过滤单课的分页
     *
     * @param goodsGroupId 商品组ID
     * @param title
     * @param pageNum
     * @param pageSize
     * @return
     */
    List<CourseDTO> getListFilterByGroupId(Long goodsGroupId, String title, Integer pageNum, Integer pageSize);

    /**
     * 统计总数
     *
     * @param goodsGroupId
     * @param title
     * @return
     */
    Long getListFilterByGroupIdCount(Long goodsGroupId, String title);

    /**
     * 分页查询课程列表
     *
     * @param requestParam
     * @return
     */
    public PageImpl<CourseDTO> getPageList(RemoteCoursePageReqParam requestParam);

    /**
     * 更新课程状态
     *
     * @param id
     * @param status
     * @return
     */
    public Boolean updateStatus(Long id, Integer status) throws BizException;

    /**
     * 分页查询课程列表,排除某专栏已关联的课程
     *
     * @param requestParam
     * @return
     */
    public PageImpl<CourseDTO> getPageListFilterByColumnId(RemoteCourseWithColumnIdPageReqParam requestParam);

    /**
     * 依据课程Id获取课程详情
     *
     * @param courseId
     * @return
     */
    public String getDetailByCourseId(Long courseId);

    /**
     * 获取课程访问地址
     *
     * @param courseId
     * @return
     */
    public String getCourseUrl(Long courseId);

    /**
     * 获取最后更新的课程
     *
     * @param columnIds 专栏id集合
     * @return
     */
    List<CourseDTO> findLastUpdateByColumnIds(List<Long> columnIds);

    /**
     * 课程播放或购买次数自增
     *
     * @param id
     * @param type 0:播放次数,1购买次数
     * @return
     */
    public boolean playOrBuyTimesIncrement(Long id, Integer type);

    /**
     * 创建课程文稿
     *
     * @param courseId
     * @param sketch
     * @return
     */
    public CourseSketchDTO createSketch(Long courseId, String sketch);

    /**
     * 修改课程文稿信息
     *
     * @param courseId
     * @param sketch
     * @return
     */
    public Boolean updateSketch(Long courseId, String sketch);

    /**
     * 依据courseId查询课程文稿信息
     *
     * @param courseId
     * @return
     */
    public CourseSketchDTO getSketchByCourseId(Long courseId);

    /**
     * 按照名称模糊搜索课程
     *
     * @param title
     * @return
     */
    List<CourseDTO> findItems(String title);

    /**
     * 瀑布流方式查询课程列表简单信息
     * @param qryParam 查询条件
     * @return 结果列表
     */
    List<CourseSimpleInfoDto> findSimpleInfoList(ColumnAndCourseQryParams qryParam);
}
