/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: RemoteReadStageService
 * Author:   amu
 * Date:     2018/5/22 下午9:00
 * Description: 一修读书阅读计划期数
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.yoofans.knowledge.center.api.remoteservice.read;

import java.util.List;
import java.util.Map;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.read.ReadStageDTO;
import cn.yoofans.knowledge.center.api.param.read.ReadStageParam;

/**
 * 〈一句话功能简述〉<br>
 * 〈一修读书阅读计划期数远程服务〉
 *
 * @author amu
 * @create 2018/5/22
 * @since 1.0.0
 */
@AdvancedFeignClient
public interface RemoteReadStageService {

    /**
     * 保存
     *
     * @param readStageDTO
     * @return
     */
    int save(ReadStageDTO readStageDTO);

    /**
     * 分页查询个数
     *
     * @param param
     * @return
     */
    Long countByPage(ReadStageParam param);

    /**
     * 分页查询
     *
     * @param param
     * @return
     */
    List<ReadStageDTO> findByPage(ReadStageParam param);

    /**
     * 获取期数详情
     *
     * @param id
     * @return
     */
    ReadStageDTO getDetail(Long id);

    /**
     * 按照id查询
     *
     * @param id
     * @return
     */
    ReadStageDTO findById(Long id);

    /**
     * 按照阅读id查询
     *
     * @param readId
     * @return
     */
    List<ReadStageDTO> findByReadId(Long readId);

    /**
     * 删除
     *
     * @return
     */
    int delete(Long id);

    Map<Long, String> findPosterTypeByIdList(List<Long> idList);

    Boolean updatePosterType();

}
