package cn.yoofans.knowledge.center.api.dto.coupon;

import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;

/**
 * 优惠券信息分页dto
 *
 * @author zhanghuifeng
 * @date 2018/4/25下午4:30
 */
public class CouponInfoDto implements Serializable {

    private static final long serialVersionUID = -8567398818316816972L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 优惠券ID
     */
    private String couponId;

    /**
     * 优惠券母版ID
     */
    private String couponTemplateId;

    /**
     * 母版标题
     */
    private String couponTemplateTitle;

    /**
     * 使用条件类型，1:满减;2:直减
     */
    private Integer conditionType;

    /**
     * 使用条件：当为满减时，为金额（分）
     */
    private Integer conditionValue;

    /**
     * 券面额（分）
     */
    private Integer couponPrice;

    /**
     * 优惠券开始日期
     */
    private Date couponStartTime;

    /**
     * 优惠券结束日期
     */
    private Date couponEndTime;

    /**
     * 使用范围，1:定向；2:通用
     */
    private Integer useScopeType;

    /**
     * 优惠券母版状态，-1:已下线；0:待上线；1:已上线
     */
    private Integer couponStatus;

    /**
     * 落地使用页面类型 1内容详情页 2:指定页面
     */
    private Integer pageType;

    /**
     * 当落地使用页面类型为指定页面时，落地使用页面商品类型，1 单课 2 专栏
     */
    private Integer pageItemType;

    /**
     * 落地使用页面课程或专栏表主键ID或内容详情页ID
     */
    private Long pageLocationId;

    /**
     * 使用时间
     */
    private Date usedTime;

    /**
     * 订单ID
     */
    private String orderId;

    /**
     * 用户ID
     */
    private Long consumerId;

    /**
     * 来源类型 1:活动
     */
    private Integer sourceType;

    /**
     * 来源id
     */
    private Long sourceId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 小程序或公众号Id
     */
    private Long authorizerId;

    /**
     * 母版主键id
     */
    private Long templateId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCouponId() {
        return couponId;
    }

    public void setCouponId(String couponId) {
        this.couponId = couponId;
    }

    public String getCouponTemplateTitle() {
        return couponTemplateTitle;
    }

    public void setCouponTemplateTitle(String couponTemplateTitle) {
        this.couponTemplateTitle = couponTemplateTitle;
    }

    public Integer getConditionType() {
        return conditionType;
    }

    public void setConditionType(Integer conditionType) {
        this.conditionType = conditionType;
    }

    public Integer getConditionValue() {
        return conditionValue;
    }

    public void setConditionValue(Integer conditionValue) {
        this.conditionValue = conditionValue;
    }

    public Integer getCouponPrice() {
        return couponPrice;
    }

    public void setCouponPrice(Integer couponPrice) {
        this.couponPrice = couponPrice;
    }

    public Date getCouponStartTime() {
        return couponStartTime;
    }

    public void setCouponStartTime(Date couponStartTime) {
        this.couponStartTime = couponStartTime;
    }

    public Date getCouponEndTime() {
        return couponEndTime;
    }

    public void setCouponEndTime(Date couponEndTime) {
        this.couponEndTime = couponEndTime;
    }

    public Integer getUseScopeType() {
        return useScopeType;
    }

    public void setUseScopeType(Integer useScopeType) {
        this.useScopeType = useScopeType;
    }

    public Integer getPageType() {
        return pageType;
    }

    public void setPageType(Integer pageType) {
        this.pageType = pageType;
    }

    public Long getPageLocationId() {
        return pageLocationId;
    }

    public void setPageLocationId(Long pageLocationId) {
        this.pageLocationId = pageLocationId;
    }

    public String getCouponTemplateId() {
        return couponTemplateId;
    }

    public void setCouponTemplateId(String couponTemplateId) {
        this.couponTemplateId = couponTemplateId;
    }

    public Date getUsedTime() {
        return usedTime;
    }

    public void setUsedTime(Date usedTime) {
        this.usedTime = usedTime;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Integer getPageItemType() {
        return pageItemType;
    }

    public void setPageItemType(Integer pageItemType) {
        this.pageItemType = pageItemType;
    }

    public Integer getCouponStatus() {
        return couponStatus;
    }

    public void setCouponStatus(Integer couponStatus) {
        this.couponStatus = couponStatus;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Long getAuthorizerId() {
        return authorizerId;
    }

    public void setAuthorizerId(Long authorizerId) {
        this.authorizerId = authorizerId;
    }

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }
}
