package cn.yoofans.knowledge.center.api.enums.coupon;

/**
 * 落地使用页面类型 1内容详情页 2:指定页面
 *
 * @author qiuyp
 */
public enum CouponPageTypeEnum {
    CONTENT_DETAIL_PAGE(1, "内容详情页"),
    SPECIFIED_PAGE(2, "指定页面");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    CouponPageTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CouponPageTypeEnum getByCode(Integer code) {
        for (CouponPageTypeEnum enumVal : CouponPageTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }
}
