package cn.yoofans.knowledge.center.api.enums.coupon;

/**
 * 优惠券母版有效期类型枚举 1领券起天数；2固定周期
 * @author qiuyp
 */
public enum CouponValidTypeEnum {
    FROM_GET_TIME(1, "领券起天数"),
    FIXED_TIME(2, "固定周期");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    CouponValidTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static CouponValidTypeEnum getByCode(Integer code) {
        for (CouponValidTypeEnum enumVal : CouponValidTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }
}
