package cn.yoofans.knowledge.center.api.param;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.crazycake.utils.CamelNameUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * 基本分页请求参数
 *
 * @author qiuyp
 */
public class BasePageReqParam implements Serializable {

    private static final long serialVersionUID = 2922776169345436048L;

    public static final String START_INDEX = "startIndex";

    public static final String PAGE_SIZE = "pageSize";

    public static final String ORDER_BY = "orderBy";

    /**
     * 页码，默认页码为1
     */
    private Integer pageNum = 1;

    /**
     * 分页大小，默认分页大小为20
     */
    private Integer pageSize = 20;

    /**
     * 开始行
     */
    private Integer startIndex;

    /**
     * 排序字段
     */
    private String columns = "gmt_create";

    /**
     * 排序顺序
     */
    private String order;

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    /**
     * 默认依据pageNum和pageSize计算startIndex的值
     *
     * @return
     */
    public Integer getStartIndex() {
        if (null == pageNum || null == pageSize)
            return startIndex;
        return (pageNum - 1) * pageSize;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public String getColumns() {
        return columns;
    }

    public void setColumns(String columns) {
        this.columns = columns;
    }

    public String getOrder() {
        return order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public BasePageReqParam() {
        super();
    }

    public BasePageReqParam(Integer pageNum, Integer pageSize) {
        super();
        this.pageNum = null == pageNum ? 1 : pageNum;
        this.pageSize = null == pageSize ? 20 : pageSize;
    }

    /**
     * 获取sql中的排序字符串
     *
     * @return
     */
    public String getOrderBy() {
        if (columns == null || columns.trim().equals("")) {
            return null;
        }
        StringBuilder orderBy = new StringBuilder("");
        String[] sorts = columns.split(",");
        String[] orders = order.split(",");
        for (int i = 0; i < sorts.length; i++) {
            orderBy.append(" " + CamelNameUtils.camel2underscore(sorts[i]) + " " + orders[i] + " ,");
        }
        if (!"".equals(orderBy.toString())) {
            orderBy.deleteCharAt(orderBy.length() - 1);
        }
        // 驼峰命名转为下划线
        return orderBy.toString();
    }

    public Pageable getPageable() {
        return new PageRequest(pageNum - 1, pageSize);
    }

    /**
     * 获取具有基本分页参数的pageMap
     */
    public Map<String, Object> getBasePageMap() {
        Map<String, Object> pageMap = new HashMap<>();
        pageMap.put(START_INDEX, this.getStartIndex());
        pageMap.put(PAGE_SIZE, this.getPageSize());
        pageMap.put(ORDER_BY, this.getOrderBy());
        return pageMap;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
