package cn.yoofans.knowledge.center.api.remoteservice.page;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.page.SkinDto;
import cn.yoofans.knowledge.center.api.param.page.SkinMarketQryParams;
import org.springframework.data.domain.PageImpl;

/**
 * 皮肤市场服务
 * @author zhanghuifeng
 * @date 2018/7/6下午3:17
 */
@AdvancedFeignClient
public interface RemoteSkinMarketService {

    /**
     * 获取皮肤详情
     * @param id 皮肤ID
     * @return 信息
     */
    SkinDto getInfo(Long id);

    /**
     * 新增皮肤
     * @param dto 参数
     * @return boolean
     */
    Boolean add(SkinDto dto);

    /**
     * 更新皮肤
     * @param dto
     * @return
     */
    Boolean update(SkinDto dto);

    /**
     * 皮肤管理分页查询
     * @param qryParams
     * @return
     */
    PageImpl<SkinDto> ListForPage(SkinMarketQryParams qryParams);
}
