package cn.yoofans.knowledge.center.api.util;

import java.math.BigDecimal;
import java.util.Random;

/**
 * Created by qiuyp on 2018/4/21.
 */
public class NumberUtils {

    /**
     * 判断数据是否为空或者为0
     *
     * @param value
     * @return
     */
    public static Boolean isNullOrZero(Integer value) {
        if (null == value) {
            return Boolean.TRUE;
        }

        if (0 == value.intValue()) {
            return Boolean.TRUE;
        }

        return Boolean.FALSE;
    }

    /**
     * 判断数据是否为空或者为0
     *
     * @param value
     * @return
     */
    public static Boolean isNullOrZero(Long value) {
        if (null == value) {
            return Boolean.TRUE;
        }

        if (0 == value.longValue()) {
            return Boolean.TRUE;
        }

        return Boolean.FALSE;
    }

    /**
     * 比较参数一是否大于参数二
     *
     * @param paramOne
     * @param paramTwo
     * @return
     */
    public static Boolean isGreater(Integer paramOne, Integer paramTwo) {
        if (null == paramOne)
            paramOne = 0;
        if (null == paramTwo)
            paramTwo = 0;
        return paramOne.compareTo(paramTwo) == 1 ? Boolean.TRUE : Boolean.FALSE;
    }

    /**
     * 比较参数一是否大于参数二
     *
     * @param paramOne
     * @param paramTwo
     * @return
     */
    public static Boolean isGreater(Long paramOne, Long paramTwo) {
        if (null == paramOne)
            paramOne = 0L;
        if (null == paramTwo)
            paramTwo = 0L;
        return paramOne.compareTo(paramTwo) == 1 ? Boolean.TRUE : Boolean.FALSE;
    }

    /**
     * 比较参数一是否小于参数二
     *
     * @param paramOne
     * @param paramTwo
     * @return
     */
    public static Boolean isSmaller(Integer paramOne, Integer paramTwo) {
        if (null == paramOne)
            paramOne = 0;
        if (null == paramTwo)
            paramTwo = 0;
        return paramOne.compareTo(paramTwo) == -1 ? Boolean.TRUE : Boolean.FALSE;
    }

    /**
     * 比较参数一是否小于参数二
     *
     * @param paramOne
     * @param paramTwo
     * @return
     */
    public static Boolean isSmaller(Long paramOne, Long paramTwo) {
        if (null == paramOne)
            paramOne = 0L;
        if (null == paramTwo)
            paramTwo = 0L;
        return paramOne.compareTo(paramTwo) == -1 ? Boolean.TRUE : Boolean.FALSE;
    }

    /**
     * 比较参数一是否等于参数二
     *
     * @param paramOne
     * @param paramTwo
     * @return
     */
    public static Boolean isEqual(Integer paramOne, Integer paramTwo) {
        if (null == paramOne)
            paramOne = 0;
        if (null == paramTwo)
            paramTwo = 0;
        return paramOne.compareTo(paramTwo) == 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    /**
     * 比较参数一是否等于参数二
     *
     * @param paramOne
     * @param paramTwo
     * @return
     */
    public static Boolean isEqual(Long paramOne, Long paramTwo) {
        if (null == paramOne)
            paramOne = 0L;
        if (null == paramTwo)
            paramTwo = 0L;
        return paramOne.compareTo(paramTwo) == 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    /**
     * 获取两个数相乘之后的Long值
     *
     * @param paramOne
     * @param paramTwo
     * @param <T>
     * @return
     */
    public static <T extends Number> Long multiplyToLong(T paramOne, T paramTwo) {
        BigDecimal multiplier = (null == paramOne) ? new BigDecimal(0L) : new BigDecimal(paramOne.doubleValue());
        BigDecimal multiple = (null == paramTwo) ? new BigDecimal(0L) : new BigDecimal(paramTwo.doubleValue());
        return multiplyToLong(multiplier, multiple);
    }

    /**
     * 获取相乘之后的Long值
     *
     * @param multiplier 被乘数
     * @param multiple   倍数
     * @return
     */
    public static Long multiplyToLong(BigDecimal multiplier, BigDecimal multiple) {
        if (null == multiplier)
            multiplier = new BigDecimal(0);
        if (null == multiple)
            multiple = new BigDecimal(0);
        BigDecimal result = multiplier.multiply(multiple);
        result.setScale(0, BigDecimal.ROUND_DOWN);
        return result.longValue();
    }

    public static int nextInt(int n) {
        return new Random().nextInt(n);
    }
}
