package cn.yoofans.knowledge.center.api.enums.coupon;

/**
 * 优惠券使用范围枚举
 * @author zhanghuifeng
 * @date 2018/4/25下午3:28
 */
public enum CouponUseScopeTypeEnum {

    ASSIGN_GOODS(1, "定向商品"),
    COMMON(2, "通用");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    CouponUseScopeTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static CouponUseScopeTypeEnum getByCode(Integer code) {
        for (CouponUseScopeTypeEnum enumVal : CouponUseScopeTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }
}
