package cn.yoofans.knowledge.center.api.remoteservice.comment;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.knowledge.center.api.dto.comment.CommentDto;
import cn.yoofans.knowledge.center.api.param.comment.CommentSearchParam;

/**
 * Created by zhangshun on 2018/5/24,13:37:09.
 */
@AdvancedFeignClient
public interface RemoteCommentService {

    /**
     * 修改观点
     */
    boolean updateById(CommentDto commentDto);

    /**
     * 修改观点
     */
    boolean updateStage(CommentDto commentDto);

    /**
     * 更新业务数据
     *
     * @return
     */
    boolean updateContentState();

    /**
     * 修改状态
     *
     * @param commentIds
     * @param status
     * @return
     */
    boolean changeStatus(String commentIds, Integer status);

    /**
     * 修改权重值
     *
     * @param commentId
     * @param sorted
     * @return
     */
    boolean changeSorted(Long commentId, Integer sorted);

    /**
     * 根据ID查询
     *
     * @param commentId
     * @return
     */
    CommentDto getById(Long commentId);

    CommentDto getByUserReadCourse(Long userId, Long readId, Long courseId);

    /**
     * 更新海报URL
     *
     * @param commentId
     * @return
     */
    boolean updateShareImgUrl(Long commentId, String imgUrl);

    /**
     * 分页查询个数
     *
     * @param param
     * @return
     */
    Long countByPage(CommentSearchParam param);

    /**
     * 分页查询
     *
     * @param param
     * @return
     */
    List<CommentDto> findByPage(CommentSearchParam param);

    boolean deleteByUserRead(Long userId, Long readId);

}
